/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.skinsrestorer.mappings.mapping1_18.Mapping1_18;
import net.skinsrestorer.mappings.shared.IMapping;
import org.bukkit.Bukkit;
import org.bukkit.UnsafeValues;

public class MappingManager {
    private static final ImmutableList<IMapping> mappings = ImmutableList.builder().add((Object)new Mapping1_18()).build();

    public static Optional<IMapping> getMapping() {
        String mappingVersion = MappingManager.getMappingsVersion();
        for (IMapping mapping : mappings) {
            if (!mapping.getSupportedVersions().contains(mappingVersion)) continue;
            return Optional.of(mapping);
        }
        return Optional.empty();
    }

    public static String getMappingsVersion() {
        UnsafeValues craftMagicNumbers = Bukkit.getServer().getUnsafe();
        try {
            Method method = craftMagicNumbers.getClass().getMethod("getMappingsVersion", new Class[0]);
            return (String)method.invoke((Object)craftMagicNumbers, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

