/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.bukkit.utils.UpdateDownloader;
import net.skinsrestorer.shared.exception.UpdateException;
import net.skinsrestorer.shared.update.DownloadCallback;
import net.skinsrestorer.shared.update.GitHubReleaseInfo;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UpdateDownloaderGithub
extends UpdateDownloader {
    private final SkinsRestorer plugin;

    public UpdateDownloaderGithub(SkinsRestorer plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    private static Runnable downloadAsync(GitHubReleaseInfo releaseInfo, File file, String userAgent, DownloadCallback callback) {
        return () -> {
            try {
                UpdateDownloaderGithub.download(releaseInfo, file, userAgent);
                callback.finished();
            }
            catch (Exception e) {
                callback.error(e);
            }
        };
    }

    private static void download(GitHubReleaseInfo releaseInfo, File file, String userAgent) {
        ReadableByteChannel channel;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(releaseInfo.latestDownloadURL).openConnection();
            connection.setRequestProperty("User-Agent", userAgent);
            if (connection.getResponseCode() != 200) {
                throw new UpdateException("Download returned status #" + connection.getResponseCode());
            }
            channel = Channels.newChannel(connection.getInputStream());
        }
        catch (IOException e) {
            throw new UpdateException("Download failed", e);
        }
        try (FileOutputStream output = new FileOutputStream(file);){
            output.getChannel().transferFrom(channel, 0L, Long.MAX_VALUE);
            output.flush();
        }
        catch (IOException e) {
            throw new UpdateException("Could not save file", e);
        }
    }

    @Override
    public boolean downloadUpdate() {
        GitHubReleaseInfo releaseInfo = (GitHubReleaseInfo)this.plugin.getUpdateChecker().getLatestResourceInfo();
        if (releaseInfo == null) {
            this.failReason = UpdateDownloader.DownloadFailReason.NOT_CHECKED;
            return false;
        }
        if (!this.plugin.getUpdateChecker().isVersionNewer(this.plugin.getUpdateChecker().getCurrentVersion(), releaseInfo.tag_name)) {
            this.failReason = UpdateDownloader.DownloadFailReason.NO_UPDATE;
            return false;
        }
        File pluginFile = this.getPluginFile();
        if (pluginFile == null) {
            this.failReason = UpdateDownloader.DownloadFailReason.NO_PLUGIN_FILE;
            return false;
        }
        File updateFolder = Bukkit.getUpdateFolderFile();
        if (!updateFolder.exists() && !updateFolder.mkdirs()) {
            this.failReason = UpdateDownloader.DownloadFailReason.NO_UPDATE_FOLDER;
            return false;
        }
        final File updateFile = new File(updateFolder, pluginFile.getName());
        this.plugin.getSrLogger().info("[GitHubUpdate] Downloading update...");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, UpdateDownloaderGithub.downloadAsync(releaseInfo, updateFile, this.plugin.getUpdateChecker().getUserAgent(), new DownloadCallback(){

            @Override
            public void finished() {
                UpdateDownloaderGithub.this.plugin.getSrLogger().info("[GitHubUpdate] Update saved as " + updateFile.getPath());
            }

            @Override
            public void error(Exception exception) {
                UpdateDownloaderGithub.this.plugin.getSrLogger().warning("[GitHubUpdate] Could not download update", exception);
            }
        }));
        return true;
    }
}

