/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.skinsrestorer.api.bungeecord.events.SkinApplyBungeeEvent;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.api.reflection.exception.ReflectionException;
import net.skinsrestorer.bungee.SkinsRestorer;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class SkinApplierBungee {
    private final SkinsRestorer plugin;
    private final SRLogger log;

    public void applySkin(String nick, InitialHandler handler) throws SkinRequestException {
        try {
            this.applySkin(null, this.plugin.getSkinStorage().getSkinForPlayer(nick), handler);
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
    }

    protected void applySkin(ProxiedPlayer player, IProperty property) {
        try {
            this.applySkin(player, property, (InitialHandler)player.getPendingConnection());
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
    }

    private void applySkin(@Nullable ProxiedPlayer player, IProperty property, InitialHandler handler) throws ReflectionException {
        if (handler == null) {
            assert (player != null);
            handler = (InitialHandler)player.getPendingConnection();
        }
        SkinApplyBungeeEvent event = new SkinApplyBungeeEvent(player, property);
        this.plugin.getProxy().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.applyWithProperty(player, handler, (LoginResult.Property)event.getProperty());
    }

    private void applyWithProperty(@Nullable ProxiedPlayer player, InitialHandler handler, LoginResult.Property textures) throws ReflectionException {
        this.applyToHandler(handler, textures);
        if (player == null) {
            return;
        }
        if (this.plugin.isMultiBungee()) {
            this.sendUpdateRequest(player, textures);
        } else {
            this.sendUpdateRequest(player, null);
        }
    }

    private void applyToHandler(InitialHandler handler, LoginResult.Property textures) throws ReflectionException {
        LoginResult profile = handler.getLoginProfile();
        LoginResult.Property[] newProps = new LoginResult.Property[]{textures};
        if (profile == null) {
            try {
                profile = new LoginResult(null, null, newProps);
            }
            catch (Exception error) {
                profile = (LoginResult)ReflectionUtil.invokeConstructor(LoginResult.class, new Class[]{String.class, LoginResult.Property[].class}, new Object[]{null, newProps});
            }
        } else {
            profile.setProperties(newProps);
        }
        ReflectionUtil.setObject(InitialHandler.class, handler, "loginProfile", profile);
    }

    private void sendUpdateRequest(@NotNull ProxiedPlayer player, LoginResult.Property textures) {
        if (player.getServer() == null) {
            return;
        }
        this.log.debug("Sending skin update request for " + player.getName());
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("SkinUpdate");
            if (textures != null) {
                out.writeUTF(textures.getName());
                out.writeUTF(textures.getValue());
                out.writeUTF(textures.getSignature());
            }
            player.getServer().sendData("sr:skinchange", b.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SkinApplierBungee(SkinsRestorer plugin, SRLogger log) {
        this.plugin = plugin;
        this.log = log;
    }
}

