/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee;

import java.io.File;
import java.io.InputStream;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.SkinsRestorerAPI;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.serverinfo.Platform;
import net.skinsrestorer.bungee.SkinApplierBungee;
import net.skinsrestorer.bungee.commands.GUICommand;
import net.skinsrestorer.bungee.commands.SkinCommand;
import net.skinsrestorer.bungee.commands.SrCommand;
import net.skinsrestorer.bungee.listeners.LoginListener;
import net.skinsrestorer.bungee.listeners.PluginMessageListener;
import net.skinsrestorer.bungee.utils.BungeeConsoleImpl;
import net.skinsrestorer.shadow.aikar.commands.BungeeCommandManager;
import net.skinsrestorer.shadow.bstats.bungeecord.Metrics;
import net.skinsrestorer.shadow.bstats.charts.SingleLineChart;
import net.skinsrestorer.shadow.spiget.UpdateCallback;
import net.skinsrestorer.shared.interfaces.ISRPlugin;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.storage.SkinStorage;
import net.skinsrestorer.shared.update.UpdateChecker;
import net.skinsrestorer.shared.update.UpdateCheckerGitHub;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.SharedMethods;
import net.skinsrestorer.shared.utils.WrapperFactory;
import net.skinsrestorer.shared.utils.connections.MineSkinAPI;
import net.skinsrestorer.shared.utils.connections.MojangAPI;
import net.skinsrestorer.shared.utils.log.LoggerImpl;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class SkinsRestorer
extends Plugin
implements ISRPlugin {
    private final File configPath = this.getDataFolder();
    private final MetricsCounter metricsCounter = new MetricsCounter();
    private final SRLogger srLogger = new SRLogger(this.getDataFolder(), new LoggerImpl(this.getProxy().getLogger(), new BungeeConsoleImpl(this.getProxy().getConsole())), true);
    private final MojangAPI mojangAPI = new MojangAPI(this.srLogger, Platform.BUNGEECORD, this.metricsCounter);
    private final MineSkinAPI mineSkinAPI = new MineSkinAPI(this.srLogger, this.mojangAPI, this.metricsCounter);
    private final SkinStorage skinStorage = new SkinStorage(this.srLogger, this.mojangAPI, this.mineSkinAPI);
    private final SkinsRestorerAPI skinsRestorerAPI = new SkinsRestorerBungeeAPI(this.mojangAPI, this.skinStorage);
    private final SkinApplierBungee skinApplierBungee = new SkinApplierBungee(this, this.srLogger);
    private boolean multiBungee;
    private boolean outdated;
    private UpdateChecker updateChecker;
    private PluginMessageListener pluginMessageListener;
    private SkinCommand skinCommand;
    private BungeeCommandManager manager;

    @Override
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public void onEnable() {
        this.srLogger.load(this.getDataFolder());
        File updaterDisabled = new File(this.getDataFolder(), "noupdate.txt");
        Metrics metrics = new Metrics(this, 1686);
        metrics.addCustomChart(new SingleLineChart("mineskin_calls", this.metricsCounter::collectMineskinCalls));
        metrics.addCustomChart(new SingleLineChart("minetools_calls", this.metricsCounter::collectMinetoolsCalls));
        metrics.addCustomChart(new SingleLineChart("mojang_calls", this.metricsCounter::collectMojangCalls));
        metrics.addCustomChart(new SingleLineChart("ashcon_calls", this.metricsCounter::collectAshconCalls));
        if (!updaterDisabled.exists()) {
            this.updateChecker = new UpdateCheckerGitHub(2124, this.getDescription().getVersion(), this.srLogger, "SkinsRestorerUpdater/BungeeCord");
            this.checkUpdate(true);
            Random rn = new Random();
            int delayInt = 60 + rn.nextInt(181);
            this.getProxy().getScheduler().schedule((Plugin)this, this::checkUpdate, (long)delayInt, (long)delayInt, TimeUnit.MINUTES);
        } else {
            this.srLogger.info("Updater Disabled");
        }
        Config.load(this.getDataFolder(), this.getResource("config.yml"), this.srLogger);
        Locale.load(this.getDataFolder(), this.srLogger);
        if (!this.initStorage()) {
            return;
        }
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new LoginListener(this, this.srLogger));
        this.initCommands();
        this.getProxy().registerChannel("sr:skinchange");
        this.getProxy().registerChannel("sr:messagechannel");
        this.pluginMessageListener = new PluginMessageListener(this);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this.pluginMessageListener);
        this.multiBungee = Config.MULTI_BUNGEE_ENABLED || ProxyServer.getInstance().getPluginManager().getPlugin("RedisBungee") != null;
        SharedMethods.runServiceCheck(this.mojangAPI, this.srLogger);
    }

    private void initCommands() {
        this.manager = new BungeeCommandManager(this);
        this.prepareACF(this.manager, this.srLogger);
        this.skinCommand = new SkinCommand(this, this.srLogger);
        this.manager.registerCommand(this.skinCommand);
        this.manager.registerCommand(new SrCommand(this, this.srLogger));
        this.manager.registerCommand(new GUICommand(this));
    }

    private boolean initStorage() {
        if (!SharedMethods.initMysql(this.srLogger, this.skinStorage, this.getDataFolder())) {
            this.getProxy().getPluginManager().unregisterListeners((Plugin)this);
            this.getProxy().getPluginManager().unregisterCommands((Plugin)this);
            return false;
        }
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, this.skinStorage::preloadDefaultSkins);
        return true;
    }

    private void checkUpdate() {
        this.checkUpdate(false);
    }

    private void checkUpdate(final boolean showUpToDate) {
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, () -> this.updateChecker.checkForUpdate(new UpdateCallback(){

            @Override
            public void updateAvailable(String newVersion, String downloadUrl, boolean hasDirectDownload) {
                SkinsRestorer.this.outdated = true;
                SkinsRestorer.this.updateChecker.getUpdateAvailableMessages(newVersion, downloadUrl, hasDirectDownload, SkinsRestorer.this.getVersion(), false).forEach(SkinsRestorer.this.srLogger::info);
            }

            @Override
            public void upToDate() {
                if (!showUpToDate) {
                    return;
                }
                SkinsRestorer.this.updateChecker.getUpToDateMessages(SkinsRestorer.this.getVersion(), false).forEach(SkinsRestorer.this.srLogger::info);
            }
        }));
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    public File getConfigPath() {
        return this.configPath;
    }

    @Override
    public MetricsCounter getMetricsCounter() {
        return this.metricsCounter;
    }

    public SRLogger getSrLogger() {
        return this.srLogger;
    }

    public MojangAPI getMojangAPI() {
        return this.mojangAPI;
    }

    public MineSkinAPI getMineSkinAPI() {
        return this.mineSkinAPI;
    }

    @Override
    public SkinStorage getSkinStorage() {
        return this.skinStorage;
    }

    public SkinsRestorerAPI getSkinsRestorerAPI() {
        return this.skinsRestorerAPI;
    }

    public SkinApplierBungee getSkinApplierBungee() {
        return this.skinApplierBungee;
    }

    public boolean isMultiBungee() {
        return this.multiBungee;
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public PluginMessageListener getPluginMessageListener() {
        return this.pluginMessageListener;
    }

    public SkinCommand getSkinCommand() {
        return this.skinCommand;
    }

    public BungeeCommandManager getManager() {
        return this.manager;
    }

    private class SkinsRestorerBungeeAPI
    extends SkinsRestorerAPI {
        public SkinsRestorerBungeeAPI(MojangAPI mojangAPI, SkinStorage skinStorage) {
            super(mojangAPI, SkinsRestorer.this.mineSkinAPI, skinStorage, new WrapperFactoryBungee());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper) throws SkinRequestException {
            this.applySkin(playerWrapper, playerWrapper.get(ProxiedPlayer.class).getName());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, String name) throws SkinRequestException {
            this.applySkin(playerWrapper, SkinsRestorer.this.skinStorage.getSkinForPlayer(name));
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, IProperty props) {
            SkinsRestorer.this.skinApplierBungee.applySkin(playerWrapper.get(ProxiedPlayer.class), props);
        }
    }

    private static class WrapperFactoryBungee
    extends WrapperFactory {
        private WrapperFactoryBungee() {
        }

        @Override
        public ISRPlayer wrap(final Object playerInstance) {
            if (playerInstance instanceof ProxiedPlayer) {
                final ProxiedPlayer player = (ProxiedPlayer)playerInstance;
                return new ISRPlayer(){

                    @Override
                    public PlayerWrapper getWrapper() {
                        return new PlayerWrapper(playerInstance);
                    }

                    @Override
                    public String getName() {
                        return player.getName();
                    }

                    @Override
                    public void sendMessage(String message) {
                        player.sendMessage(TextComponent.fromLegacyText((String)message));
                    }
                };
            }
            throw new IllegalArgumentException("Player instance is not valid!");
        }
    }
}

