/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee.commands;

import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.skinsrestorer.bungee.SkinsRestorer;
import net.skinsrestorer.shadow.aikar.commands.BaseCommand;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandAlias;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandPermission;
import net.skinsrestorer.shadow.aikar.commands.annotation.Default;
import net.skinsrestorer.shadow.aikar.commands.annotation.HelpCommand;
import net.skinsrestorer.shared.storage.CooldownStorage;
import net.skinsrestorer.shared.storage.Locale;

@CommandAlias(value="skins")
@CommandPermission(value="%skins")
public class GUICommand
extends BaseCommand {
    private final SkinsRestorer plugin;

    @HelpCommand
    public static void onHelp(CommandSender sender, CommandHelp help) {
        sender.sendMessage(TextComponent.fromLegacyText((String)"SkinsRestorer Help"));
        help.showHelp();
    }

    @Default
    @CommandPermission(value="%skins")
    public void onDefault(ProxiedPlayer player) {
        if (!player.hasPermission("skinsrestorer.bypasscooldown") && CooldownStorage.hasCooldown(player.getName())) {
            player.sendMessage(TextComponent.fromLegacyText((String)Locale.SKIN_COOLDOWN.replace("%s", String.valueOf(CooldownStorage.getCooldown(player.getName())))));
            return;
        }
        player.sendMessage(TextComponent.fromLegacyText((String)Locale.SKINSMENU_OPEN));
        this.plugin.getPluginMessageListener().sendGuiOpenRequest(player);
    }

    public GUICommand(SkinsRestorer plugin) {
        this.plugin = plugin;
    }
}

