/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee.commands;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.bungee.SkinsRestorer;
import net.skinsrestorer.shadow.aikar.commands.BaseCommand;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandAlias;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandCompletion;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandPermission;
import net.skinsrestorer.shadow.aikar.commands.annotation.Description;
import net.skinsrestorer.shadow.aikar.commands.annotation.HelpCommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Optional;
import net.skinsrestorer.shadow.aikar.commands.annotation.Single;
import net.skinsrestorer.shadow.aikar.commands.annotation.Subcommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Syntax;
import net.skinsrestorer.shadow.aikar.commands.bungee.contexts.OnlinePlayer;
import net.skinsrestorer.shadow.gson.JsonObject;
import net.skinsrestorer.shadow.gson.JsonParser;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.utils.C;
import net.skinsrestorer.shared.utils.connections.ServiceChecker;
import net.skinsrestorer.shared.utils.log.SRLogger;

@CommandAlias(value="sr|skinsrestorer")
@CommandPermission(value="%sr")
public class SrCommand
extends BaseCommand {
    private final SkinsRestorer plugin;
    private final SRLogger logger;

    @HelpCommand
    @Syntax(value=" [help]")
    public void onHelp(CommandSender sender, CommandHelp help) {
        help.showHelp();
    }

    @Subcommand(value="reload")
    @CommandPermission(value="%srReload")
    @Description(value="%helpSrReload")
    public void onReload(CommandSender sender) {
        Locale.load(this.plugin.getConfigPath(), this.logger);
        Config.load(this.plugin.getConfigPath(), this.plugin.getResourceAsStream("config.yml"), this.logger);
        this.plugin.prepareACF(this.plugin.getManager(), this.plugin.getSrLogger());
        sender.sendMessage(TextComponent.fromLegacyText((String)Locale.RELOAD));
    }

    @Subcommand(value="status")
    @CommandPermission(value="%srStatus")
    @Description(value="%helpSrStatus")
    public void onStatus(CommandSender sender) {
        sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a73----------------------------------------------"));
        sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a77Checking needed services for SR to work properly..."));
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, () -> {
            ServiceChecker checker = new ServiceChecker();
            checker.setMojangAPI(this.plugin.getMojangAPI());
            checker.checkServices();
            ServiceChecker.ServiceCheckResponse response = checker.getResponse();
            List<String> results = response.getResults();
            if (Config.DEBUG || response.getWorkingUUID().get() < 1 || response.getWorkingProfile().get() < 1) {
                for (String result : results) {
                    if (!Config.DEBUG && !result.contains("\u2718")) continue;
                    sender.sendMessage(TextComponent.fromLegacyText((String)result));
                }
            }
            sender.sendMessage(TextComponent.fromLegacyText((String)("\u00a77Working UUID API count: \u00a76 " + response.getWorkingUUID())));
            sender.sendMessage(TextComponent.fromLegacyText((String)("\u00a77Working Profile API count: \u00a76" + response.getWorkingProfile())));
            if (response.getWorkingUUID().get() >= 1 && response.getWorkingProfile().get() >= 1) {
                sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a7aThe plugin currently is in a working state."));
            } else {
                sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a7cPlugin currently can't fetch new skins. \n Connection is likely blocked because of firewall. \n Please See http://skinsrestorer.net/firewall for more info"));
            }
            sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a73----------------------------------------------"));
            sender.sendMessage(TextComponent.fromLegacyText((String)("\u00a77SkinsRestorer \u00a76v" + this.plugin.getVersion())));
            sender.sendMessage(TextComponent.fromLegacyText((String)("\u00a77Server: \u00a76" + this.plugin.getProxy().getVersion())));
            sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a77BungeeMode: \u00a76Bungee-Plugin"));
            sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a77Finished checking services."));
            sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a73----------------------------------------------"));
        });
    }

    @Subcommand(value="drop|remove")
    @CommandPermission(value="%srDrop")
    @CommandCompletion(value="PLAYER|SKIN @players @players @players")
    @Description(value="%helpSrDrop")
    @Syntax(value=" <player|skin> <target> [target2]")
    public void onDrop(CommandSender sender, PlayerOrSkin playerOrSkin, String[] targets) {
        if (playerOrSkin == PlayerOrSkin.PLAYER) {
            for (String targetPlayer : targets) {
                this.plugin.getSkinStorage().removeSkin(targetPlayer);
            }
        } else {
            for (String targetSkin : targets) {
                this.plugin.getSkinStorage().removeSkinData(targetSkin);
            }
        }
        String targetList = Arrays.toString(targets).substring(1, Arrays.toString(targets).length() - 1);
        sender.sendMessage(TextComponent.fromLegacyText((String)Locale.DATA_DROPPED.replace("%playerOrSkin", playerOrSkin.toString()).replace("%targets", targetList)));
    }

    @Subcommand(value="props")
    @CommandPermission(value="%srProps")
    @CommandCompletion(value="@players")
    @Description(value="%helpSrProps")
    @Syntax(value=" <target>")
    public void onProps(CommandSender sender, @Single OnlinePlayer target) {
        LoginResult.Property prop = ((InitialHandler)target.getPlayer().getPendingConnection()).getLoginProfile().getProperties()[0];
        if (prop == null) {
            sender.sendMessage(TextComponent.fromLegacyText((String)Locale.NO_SKIN_DATA));
            return;
        }
        byte[] decoded = Base64.getDecoder().decode(prop.getValue());
        String decodedString = new String(decoded);
        JsonObject jsonObject = JsonParser.parseString(decodedString).getAsJsonObject();
        String decodedSkin = jsonObject.getAsJsonObject().get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").toString();
        long timestamp = Long.parseLong(jsonObject.getAsJsonObject().get("timestamp").toString());
        String requestDate = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(timestamp));
        sender.sendMessage(TextComponent.fromLegacyText((String)("\u00a7aRequest time: \u00a7e" + requestDate)));
        sender.sendMessage(TextComponent.fromLegacyText((String)("\u00a7aprofileId: \u00a7e" + jsonObject.getAsJsonObject().get("profileId").toString())));
        sender.sendMessage(TextComponent.fromLegacyText((String)("\u00a7aName: \u00a7e" + jsonObject.getAsJsonObject().get("profileName").toString())));
        sender.sendMessage(TextComponent.fromLegacyText((String)("\u00a7aSkinTexture: \u00a7e" + decodedSkin.substring(1, decodedSkin.length() - 1))));
        sender.sendMessage(TextComponent.fromLegacyText((String)"\u00a7cMore info in console!"));
        this.logger.info("\u00a7aName: \u00a78" + prop.getName());
        this.logger.info("\u00a7aValue : \u00a78" + prop.getValue());
        this.logger.info("\u00a7aSignature : \u00a78" + prop.getSignature());
        this.logger.info("\u00a7aValue Decoded: \u00a7e" + Arrays.toString(decoded));
    }

    @Subcommand(value="applyskin")
    @CommandPermission(value="%srApplySkin")
    @CommandCompletion(value="@players")
    @Description(value="%helpSrApplySkin")
    @Syntax(value=" <target>")
    public void onApplySkin(CommandSender sender, @Single OnlinePlayer target) {
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, () -> {
            try {
                ProxiedPlayer player = target.getPlayer();
                String name = player.getName();
                String skin = this.plugin.getSkinStorage().getDefaultSkinName(name);
                this.plugin.getSkinsRestorerAPI().applySkin(new PlayerWrapper(player), skin);
                sender.sendMessage(TextComponent.fromLegacyText((String)"success: player skin has been refreshed!"));
            }
            catch (Exception ignored) {
                sender.sendMessage(TextComponent.fromLegacyText((String)"ERROR: player skin could NOT be refreshed!"));
            }
        });
    }

    @Subcommand(value="createcustom")
    @CommandPermission(value="%srCreateCustom")
    @CommandCompletion(value="@skinName @skinUrl")
    @Description(value="%helpSrCreateCustom")
    @Syntax(value=" <skinName> <skinUrl> [steve/slim]")
    public void onCreateCustom(CommandSender sender, String skinName, String skinUrl, @Optional SkinType skinType) {
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, () -> {
            try {
                if (C.validUrl(skinUrl)) {
                    this.plugin.getSkinStorage().setSkinData(skinName, this.plugin.getMineSkinAPI().genSkin(skinUrl, String.valueOf((Object)skinType), null), Long.toString(System.currentTimeMillis() + 3153600000000L));
                    sender.sendMessage(TextComponent.fromLegacyText((String)Locale.SUCCESS_CREATE_SKIN.replace("%skin", skinName)));
                } else {
                    sender.sendMessage(TextComponent.fromLegacyText((String)Locale.ERROR_INVALID_URLSKIN));
                }
            }
            catch (SkinRequestException e) {
                sender.sendMessage(TextComponent.fromLegacyText((String)e.getMessage()));
            }
        });
    }

    @Subcommand(value="setskinall")
    @CommandCompletion(value="@Skin")
    @Description(value="Set the skin to evey player")
    @Syntax(value=" <Skin / Url> [steve/slim]")
    public void onSetSkinAll(CommandSender sender, String skin, @Optional SkinType skinType) {
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, () -> {
            if (sender != ProxyServer.getInstance().getConsole()) {
                sender.sendMessage(TextComponent.fromLegacyText((String)(Locale.PREFIX + "\u00a74Only console may execute this command!")));
                return;
            }
            String skinName = " \u00b7setSkinAll";
            try {
                IProperty skinProps = null;
                skinProps = C.validUrl(skin) ? this.plugin.getMineSkinAPI().genSkin(skin, String.valueOf((Object)skinType), null) : (IProperty)this.plugin.getMojangAPI().getSkin(skin).orElse(null);
                if (skinProps == null) {
                    sender.sendMessage(TextComponent.fromLegacyText((String)(Locale.PREFIX + "\u00a74no skin found....")));
                    return;
                }
                this.plugin.getSkinStorage().setSkinData(skinName, skinProps);
                for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
                    String pName = player.getName();
                    this.plugin.getSkinStorage().setSkinName(pName, skinName);
                    this.plugin.getSkinsRestorerAPI().applySkin(new PlayerWrapper(player), skinProps);
                }
            }
            catch (SkinRequestException e) {
                sender.sendMessage(TextComponent.fromLegacyText((String)e.getMessage()));
            }
        });
    }

    public SrCommand(SkinsRestorer plugin, SRLogger logger) {
        this.plugin = plugin;
        this.logger = logger;
    }

    public static enum PlayerOrSkin {
        PLAYER,
        SKIN;

    }

    public static enum SkinType {
        STEVE,
        SLIM;

    }
}

