/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee.listeners;

import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.event.EventHandler;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.bungee.SkinsRestorer;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class LoginListener
implements Listener {
    private final SkinsRestorer plugin;
    private final SRLogger log;

    @EventHandler(priority=32)
    public void onLogin(LoginEvent event) {
        if (event.isCancelled() && Config.NO_SKIN_IF_LOGIN_CANCELED) {
            return;
        }
        if (Config.DISABLE_ON_JOIN_SKINS) {
            return;
        }
        event.registerIntent((Plugin)this.plugin);
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
            PendingConnection connection = event.getConnection();
            String skin = this.plugin.getSkinStorage().getDefaultSkinName(connection.getName());
            try {
                this.plugin.getSkinApplierBungee().applySkin(skin, (InitialHandler)connection);
            }
            catch (SkinRequestException skinRequestException) {
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            event.completeIntent((Plugin)this.plugin);
        });
    }

    @EventHandler(priority=32)
    public void onServerConnect(ServerConnectEvent e) {
        if (e.isCancelled()) {
            return;
        }
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
            ProxiedPlayer player;
            if (this.plugin.isOutdated() && (player = e.getPlayer()).hasPermission("skinsrestorer.admincommand")) {
                player.sendMessage(TextComponent.fromLegacyText((String)Locale.OUTDATED));
            }
        });
    }

    public LoginListener(SkinsRestorer plugin, SRLogger log) {
        this.plugin = plugin;
        this.log = log;
    }
}

