/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee.listeners;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import net.skinsrestorer.api.property.GenericProperty;
import net.skinsrestorer.bungee.SkinsRestorer;
import net.skinsrestorer.shadow.aikar.commands.bungee.contexts.OnlinePlayer;

public class PluginMessageListener
implements Listener {
    private final SkinsRestorer plugin;

    private static byte[] convertToByteArray(Map<String, GenericProperty> map) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(map);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return byteOut.toByteArray();
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent event) throws IOException {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getTag().equals("sr:messagechannel") && !event.getTag().equals("sr:skinchange")) {
            return;
        }
        if (!(event.getSender() instanceof ServerConnection)) {
            event.setCancelled(true);
            return;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(event.getData()));
        String subChannel = in.readUTF();
        String playerName = in.readUTF();
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(playerName);
        switch (subChannel) {
            case "getSkins": {
                int page = in.readInt();
                if (page > 999) {
                    page = 999;
                }
                int skinNumber = 26 * page;
                Map<String, GenericProperty> skinsList = this.plugin.getSkinStorage().getSkinsRaw(skinNumber);
                byte[] ba = PluginMessageListener.convertToByteArray(skinsList);
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(b);
                try {
                    out.writeUTF("returnSkins");
                    out.writeUTF(playerName);
                    out.writeInt(page);
                    out.writeShort(ba.length);
                    out.write(ba);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                player.getServer().sendData("sr:messagechannel", b.toByteArray());
                break;
            }
            case "clearSkin": {
                this.plugin.getSkinCommand().onSkinClearOther((CommandSender)player, new OnlinePlayer(player));
                break;
            }
            case "updateSkin": {
                this.plugin.getSkinCommand().onSkinUpdateOther((CommandSender)player, new OnlinePlayer(player));
                break;
            }
            case "setSkin": {
                String skin = in.readUTF();
                this.plugin.getSkinCommand().onSkinSetOther((CommandSender)player, new OnlinePlayer(player), skin, null);
                break;
            }
        }
    }

    public void sendGuiOpenRequest(ProxiedPlayer player) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("OPENGUI");
            out.writeUTF(player.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.getServer().sendData("sr:messagechannel", b.toByteArray());
    }

    public PluginMessageListener(SkinsRestorer plugin) {
        this.plugin = plugin;
    }
}

