/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.skinsrestorer.shadow.aikar.commands.ACFPatterns;
import net.skinsrestorer.shadow.aikar.commands.ACFUtil;
import net.skinsrestorer.shadow.aikar.commands.CommandIssuer;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.aikar.commands.MinecraftMessageKeys;

public class ACFBungeeUtil {
    public static final char COLOR_CHAR = '\u00a7';

    public static String color(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    @Deprecated
    public static void sendMsg(CommandSender player, String message) {
        message = ACFBungeeUtil.color(message);
        for (String msg : ACFPatterns.NEWLINE.split(message)) {
            player.sendMessage(msg);
        }
    }

    public static String removeColors(String msg) {
        return ChatColor.stripColor((String)ACFBungeeUtil.color(msg));
    }

    public static String replaceChatString(String message, String replace, String with) {
        return ACFBungeeUtil.replaceChatString(message, Pattern.compile(Pattern.quote(replace), 2), with);
    }

    public static String replaceChatString(String message, Pattern replace, String with) {
        String[] split = replace.split(message + "1");
        if (split.length < 2) {
            return replace.matcher(message).replaceAll(with);
        }
        message = split[0];
        for (int i = 1; i < split.length; ++i) {
            String prev = ACFBungeeUtil.getLastColors(message);
            message = message + with + prev + split[i];
        }
        return message.substring(0, message.length() - 1);
    }

    public static String getLastColors(String input) {
        StringBuilder result = new StringBuilder();
        int length = input.length();
        for (int index = length - 1; index > -1; --index) {
            char c;
            ChatColor color;
            char section = input.charAt(index);
            if (section != '\u00a7' || index >= length - 1 || (color = ChatColor.getByChar((char)(c = input.charAt(index + 1)))) == null) continue;
            result.insert(0, color.toString());
            if (ACFBungeeUtil.isChatColorAColor(color) || color.equals((Object)ChatColor.RESET)) break;
        }
        return result.toString();
    }

    public static boolean isChatColorAColor(ChatColor chatColor) {
        return chatColor != ChatColor.MAGIC && chatColor != ChatColor.BOLD && chatColor != ChatColor.STRIKETHROUGH && chatColor != ChatColor.UNDERLINE && chatColor != ChatColor.ITALIC;
    }

    public static ProxiedPlayer findPlayerSmart(CommandIssuer issuer, String search) {
        CommandSender requester = (CommandSender)issuer.getIssuer();
        String name = ACFUtil.replace(search, ":confirm", "");
        if (!ACFBungeeUtil.isValidName(name)) {
            issuer.sendError(MinecraftMessageKeys.IS_NOT_A_VALID_NAME, "{name}", name);
            return null;
        }
        ArrayList matches = new ArrayList(ProxyServer.getInstance().matchPlayer(name));
        if (matches.size() > 1) {
            String allMatches = matches.stream().map(CommandSender::getName).collect(Collectors.joining(", "));
            issuer.sendError(MinecraftMessageKeys.MULTIPLE_PLAYERS_MATCH, "{search}", name, "{all}", allMatches);
            return null;
        }
        if (matches.isEmpty()) {
            issuer.sendError(MinecraftMessageKeys.NO_PLAYER_FOUND_SERVER, "{search}", name);
            return null;
        }
        return (ProxiedPlayer)matches.get(0);
    }

    public static ProxiedPlayer findPlayerSmart(CommandSender requester, String search) {
        CommandManager manager = CommandManager.getCurrentCommandManager();
        if (manager != null) {
            return ACFBungeeUtil.findPlayerSmart(manager.getCommandIssuer(requester), search);
        }
        throw new IllegalStateException("You may not use the ACFBungeeUtil#findPlayerSmart(CommandSender) async to the command execution.");
    }

    public static boolean isValidName(String name) {
        return name != null && !name.isEmpty() && ACFPatterns.VALID_NAME_PATTERN.matcher(name).matches();
    }

    public static <T> T validate(T object, String message, Object ... values) {
        if (object == null) {
            throw new NullPointerException(String.format(message, values));
        }
        return object;
    }
}

