/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.PlayerSettingsChangedEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.concurrent.TimeUnit;
import net.skinsrestorer.shadow.aikar.commands.VelocityCommandManager;

public class ACFVelocityListener {
    private final VelocityCommandManager manager;
    private final PluginContainer plugin;
    private final ProxyServer proxy;

    public ACFVelocityListener(VelocityCommandManager manager, PluginContainer plugin, ProxyServer proxy) {
        this.manager = manager;
        this.plugin = plugin;
        this.proxy = proxy;
    }

    @Subscribe
    public void onPlayerJoin(PostLoginEvent loginEvent) {
        Player player = loginEvent.getPlayer();
        Runnable task = () -> this.manager.readLocale(player);
        this.proxy.getScheduler().buildTask((Object)this.plugin, task).delay(1L, TimeUnit.SECONDS).schedule();
    }

    @Subscribe
    public void onDisconnect(DisconnectEvent disconnectEvent) {
        Player player = disconnectEvent.getPlayer();
        this.manager.issuersLocale.remove(player.getUniqueId());
    }

    @Subscribe
    public void onSettingsChange(PlayerSettingsChangedEvent settingsEvent) {
        this.manager.setIssuerLocale(settingsEvent.getPlayer(), settingsEvent.getPlayer().getPlayerSettings().getLocale());
    }
}

