/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.skinsrestorer.shadow.aikar.commands.ACFPatterns;
import net.skinsrestorer.shadow.aikar.commands.ACFUtil;
import net.skinsrestorer.shadow.aikar.commands.CommandIssuer;
import net.skinsrestorer.shadow.aikar.commands.MinecraftMessageKeys;

public class ACFVelocityUtil {
    public static TextComponent color(String message) {
        return LegacyComponentSerializer.legacySection().deserialize(message);
    }

    public static Player findPlayerSmart(ProxyServer server, CommandIssuer issuer, String search) {
        CommandSource requester = (CommandSource)issuer.getIssuer();
        String name = ACFUtil.replace(search, ":confirm", "");
        if (!ACFVelocityUtil.isValidName(name)) {
            issuer.sendError(MinecraftMessageKeys.IS_NOT_A_VALID_NAME, "{name}", name);
            return null;
        }
        ArrayList<Player> matches = new ArrayList<Player>(ACFVelocityUtil.matchPlayer(server, name));
        if (matches.size() > 1) {
            String allMatches = matches.stream().map(Player::getUsername).collect(Collectors.joining(", "));
            issuer.sendError(MinecraftMessageKeys.MULTIPLE_PLAYERS_MATCH, "{search}", name, "{all}", allMatches);
            return null;
        }
        if (matches.isEmpty()) {
            issuer.sendError(MinecraftMessageKeys.NO_PLAYER_FOUND_SERVER, "{search}", name);
            return null;
        }
        return (Player)matches.get(0);
    }

    private static Collection<Player> matchPlayer(ProxyServer server, String partialName) {
        if (partialName == null) {
            throw new NullPointerException("partialName");
        }
        Optional exactMatch = server.getPlayer(partialName);
        if (exactMatch.isPresent()) {
            return Collections.singleton(exactMatch.get());
        }
        return server.getAllPlayers().stream().filter(player -> player.getUsername().regionMatches(true, 0, partialName, 0, partialName.length())).collect(Collectors.toList());
    }

    public static boolean isValidName(String name) {
        return name != null && !name.isEmpty() && ACFPatterns.VALID_NAME_PATTERN.matcher(name).matches();
    }

    public static <T> T validate(T object, String message, Object ... values) {
        if (object == null) {
            throw new NullPointerException(String.format(message, values));
        }
        return object;
    }
}

