/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import net.skinsrestorer.shadow.aikar.commands.ACFBukkitUtil;
import net.skinsrestorer.shadow.aikar.commands.BukkitCommandManager;
import net.skinsrestorer.shadow.aikar.commands.CommandIssuer;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitCommandIssuer
implements CommandIssuer {
    private final BukkitCommandManager manager;
    private final CommandSender sender;

    BukkitCommandIssuer(BukkitCommandManager manager, CommandSender sender) {
        this.manager = manager;
        this.sender = sender;
    }

    @Override
    public boolean isPlayer() {
        return this.sender instanceof Player;
    }

    public CommandSender getIssuer() {
        return this.sender;
    }

    public Player getPlayer() {
        return this.isPlayer() ? (Player)this.sender : null;
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        if (this.isPlayer()) {
            return ((Player)this.sender).getUniqueId();
        }
        return UUID.nameUUIDFromBytes(this.sender.getName().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public CommandManager getManager() {
        return this.manager;
    }

    @Override
    public void sendMessageInternal(String message) {
        this.sender.sendMessage(ACFBukkitUtil.color(message));
    }

    @Override
    public boolean hasPermission(String name) {
        return this.sender.hasPermission(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BukkitCommandIssuer that = (BukkitCommandIssuer)o;
        return Objects.equals(this.sender, that.sender);
    }

    public int hashCode() {
        return Objects.hash(this.sender);
    }
}

