/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.skinsrestorer.shadow.aikar.commands.ACFBungeeUtil;
import net.skinsrestorer.shadow.aikar.commands.ACFUtil;
import net.skinsrestorer.shadow.aikar.commands.BungeeCommandExecutionContext;
import net.skinsrestorer.shadow.aikar.commands.CommandContexts;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.aikar.commands.InvalidCommandArgument;
import net.skinsrestorer.shadow.aikar.commands.MessageKeys;
import net.skinsrestorer.shadow.aikar.commands.annotation.Optional;
import net.skinsrestorer.shadow.aikar.commands.bungee.contexts.OnlinePlayer;
import net.skinsrestorer.shadow.aikar.commands.contexts.OnlineProxiedPlayer;
import net.skinsrestorer.shadow.aikar.locales.MessageKeyProvider;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class BungeeCommandContexts
extends CommandContexts<BungeeCommandExecutionContext> {
    BungeeCommandContexts(CommandManager manager) {
        super(manager);
        this.registerContext(OnlinePlayer.class, this::getOnlinePlayer);
        this.registerContext(OnlineProxiedPlayer.class, c -> {
            OnlineProxiedPlayer onlinePlayer = this.getOnlinePlayer((BungeeCommandExecutionContext)c);
            return onlinePlayer != null ? new OnlineProxiedPlayer(onlinePlayer.getPlayer()) : null;
        });
        this.registerIssuerAwareContext(CommandSender.class, BungeeCommandExecutionContext::getSender);
        this.registerIssuerAwareContext(ProxiedPlayer.class, c -> {
            ProxiedPlayer proxiedPlayer;
            ProxiedPlayer proxiedPlayer2 = proxiedPlayer = c.getSender() instanceof ProxiedPlayer ? (ProxiedPlayer)c.getSender() : null;
            if (proxiedPlayer == null && !c.hasAnnotation(Optional.class)) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.NOT_ALLOWED_ON_CONSOLE, false, new String[0]);
            }
            return proxiedPlayer;
        });
        this.registerContext(ChatColor.class, c -> {
            ChatColor match;
            String filter;
            String first = c.popFirstArg();
            Stream<ChatColor> colors = Stream.of(ChatColor.values());
            if (c.hasFlag("colorsonly")) {
                colors = colors.filter(color -> color.ordinal() <= 15);
            }
            if ((filter = c.getFlagValue("filter", (String)null)) != null) {
                String finalFilter = filter = ACFUtil.simplifyString(filter);
                colors = colors.filter(color -> finalFilter.equals(ACFUtil.simplifyString(color.name())));
            }
            if ((match = (ChatColor)ACFUtil.simpleMatch(ChatColor.class, first)) == null) {
                String valid = colors.map(color -> "<c2>" + ACFUtil.simplifyString(color.name()) + "</c2>").collect(Collectors.joining("<c1>,</c1> "));
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_ONE_OF, "{valid}", valid);
            }
            return match;
        });
    }

    @Nullable
    private OnlineProxiedPlayer getOnlinePlayer(BungeeCommandExecutionContext c) throws InvalidCommandArgument {
        ProxiedPlayer proxiedPlayer = ACFBungeeUtil.findPlayerSmart(c.getIssuer(), c.popFirstArg());
        if (proxiedPlayer == null) {
            if (c.hasAnnotation(Optional.class)) {
                return null;
            }
            throw new InvalidCommandArgument(false);
        }
        return new OnlineProxiedPlayer(proxiedPlayer);
    }
}

