/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.skinsrestorer.shadow.aikar.commands.ACFBungeeUtil;
import net.skinsrestorer.shadow.aikar.commands.BungeeCommandManager;
import net.skinsrestorer.shadow.aikar.commands.CommandIssuer;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.jbannotations.NotNull;

public class BungeeCommandIssuer
implements CommandIssuer {
    private final BungeeCommandManager manager;
    private final CommandSender sender;

    BungeeCommandIssuer(BungeeCommandManager manager, CommandSender sender) {
        this.manager = manager;
        this.sender = sender;
    }

    public CommandSender getIssuer() {
        return this.sender;
    }

    public ProxiedPlayer getPlayer() {
        return this.isPlayer() ? (ProxiedPlayer)this.sender : null;
    }

    @Override
    public CommandManager getManager() {
        return this.manager;
    }

    @Override
    public boolean isPlayer() {
        return this.sender instanceof ProxiedPlayer;
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        if (this.isPlayer()) {
            return ((ProxiedPlayer)this.sender).getUniqueId();
        }
        return UUID.nameUUIDFromBytes(this.sender.getName().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void sendMessageInternal(String message) {
        this.sender.sendMessage(ACFBungeeUtil.color(message));
    }

    @Override
    public boolean hasPermission(String name) {
        return this.sender.hasPermission(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BungeeCommandIssuer that = (BungeeCommandIssuer)o;
        return Objects.equals(this.sender, that.sender);
    }

    public int hashCode() {
        return Objects.hash(this.sender);
    }
}

