/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import java.util.UUID;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.aikar.commands.MessageKeys;
import net.skinsrestorer.shadow.aikar.commands.MessageType;
import net.skinsrestorer.shadow.aikar.locales.MessageKey;
import net.skinsrestorer.shadow.aikar.locales.MessageKeyProvider;
import net.skinsrestorer.shadow.jbannotations.NotNull;

public interface CommandIssuer {
    public <T> T getIssuer();

    public CommandManager getManager();

    public boolean isPlayer();

    default public void sendMessage(String message) {
        this.getManager().sendMessage(this, MessageType.INFO, (MessageKeyProvider)MessageKeys.INFO_MESSAGE, "{message}", message);
    }

    @NotNull
    public UUID getUniqueId();

    public boolean hasPermission(String var1);

    default public void sendError(MessageKeyProvider key, String ... replacements) {
        this.sendMessage(MessageType.ERROR, key.getMessageKey(), replacements);
    }

    default public void sendSyntax(MessageKeyProvider key, String ... replacements) {
        this.sendMessage(MessageType.SYNTAX, key.getMessageKey(), replacements);
    }

    default public void sendInfo(MessageKeyProvider key, String ... replacements) {
        this.sendMessage(MessageType.INFO, key.getMessageKey(), replacements);
    }

    default public void sendError(MessageKey key, String ... replacements) {
        this.sendMessage(MessageType.ERROR, key, replacements);
    }

    default public void sendSyntax(MessageKey key, String ... replacements) {
        this.sendMessage(MessageType.SYNTAX, key, replacements);
    }

    default public void sendInfo(MessageKey key, String ... replacements) {
        this.sendMessage(MessageType.INFO, key, replacements);
    }

    default public void sendMessage(MessageType type, MessageKeyProvider key, String ... replacements) {
        this.sendMessage(type, key.getMessageKey(), replacements);
    }

    default public void sendMessage(MessageType type, MessageKey key, String ... replacements) {
        this.getManager().sendMessage(this, type, (MessageKeyProvider)key, replacements);
    }

    @Deprecated
    public void sendMessageInternal(String var1);
}

