/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.bstats.sponge;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.skinsrestorer.shadow.bstats.MetricsBase;
import net.skinsrestorer.shadow.bstats.charts.CustomChart;
import net.skinsrestorer.shadow.bstats.json.JsonObjectBuilder;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.Task;

public class Metrics {
    private final PluginContainer plugin;
    private final Logger logger;
    private final Path configDir;
    private final int serviceId;
    private MetricsBase metricsBase;
    private String serverUUID;
    private boolean logErrors = false;
    private boolean logSentData;
    private boolean logResponseStatusText;

    private Metrics(PluginContainer plugin, Logger logger, Path configDir, int serviceId) {
        this.plugin = plugin;
        this.logger = logger;
        this.configDir = configDir;
        this.serviceId = serviceId;
        Sponge.getEventManager().registerListeners((Object)plugin, (Object)this);
    }

    @Listener
    public void startup(GamePreInitializationEvent event) {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            this.logger.warn("Failed to load bStats config!", (Throwable)e);
            return;
        }
        this.metricsBase = new MetricsBase("sponge", this.serverUUID, this.serviceId, Sponge.getMetricsConfigManager().areMetricsEnabled(this.plugin), this::appendPlatformData, this::appendServiceData, task -> {
            Scheduler scheduler = Sponge.getScheduler();
            Task.Builder taskBuilder = scheduler.createTaskBuilder();
            taskBuilder.execute(task).submit((Object)this.plugin);
        }, () -> true, (arg_0, arg_1) -> ((Logger)this.logger).warn(arg_0, arg_1), arg_0 -> ((Logger)this.logger).info(arg_0), this.logErrors, this.logSentData, this.logResponseStatusText);
        StringBuilder builder = new StringBuilder().append(System.lineSeparator());
        builder.append("Plugin ").append(this.plugin.getName()).append(" is using bStats Metrics ");
        if (Sponge.getMetricsConfigManager().areMetricsEnabled(this.plugin)) {
            builder.append(" and is allowed to send data.");
        } else {
            builder.append(" but currently has data sending disabled.").append(System.lineSeparator());
            builder.append("To change the enabled/disabled state of any bStats use in a plugin, visit the Sponge config!");
        }
        this.logger.info(builder.toString());
    }

    private void loadConfig() throws IOException {
        CommentedConfigurationNode node;
        File configPath = this.configDir.resolve("bStats").toFile();
        configPath.mkdirs();
        File configFile = new File(configPath, "config.conf");
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(configFile)).build();
        String serverUuidComment = "bStats (https://bStats.org) collects some basic information for plugin authors, like how\nmany people use their plugin and their total player count. It's recommended to keep bStats\nenabled, but if you're not comfortable with this, you can disable data collection in the\nSponge configuration file. There is no performance penalty associated with having metrics\nenabled, and data sent to bStats is fully anonymous.";
        if (!configFile.exists()) {
            configFile.createNewFile();
            node = (CommentedConfigurationNode)configurationLoader.load();
            node.getNode(new Object[]{"serverUuid"}).setValue((Object)UUID.randomUUID().toString());
            node.getNode(new Object[]{"logFailedRequests"}).setValue((Object)false);
            node.getNode(new Object[]{"logSentData"}).setValue((Object)false);
            node.getNode(new Object[]{"logResponseStatusText"}).setValue((Object)false);
            node.getNode(new Object[]{"serverUuid"}).setComment(serverUuidComment);
            node.getNode(new Object[]{"configVersion"}).setValue((Object)2);
            configurationLoader.save((ConfigurationNode)node);
        } else {
            node = (CommentedConfigurationNode)configurationLoader.load();
            if (!node.getNode(new Object[]{"configVersion"}).isVirtual()) {
                node.getNode(new Object[]{"configVersion"}).setValue((Object)2);
                node.getNode(new Object[]{"enabled"}).setComment("Enabling bStats in this file is deprecated. At least one of your plugins now uses the\nSponge config to control bStats. Leave this value as you want it to be for outdated plugins,\nbut look there for further control");
                node.getNode(new Object[]{"serverUuid"}).setComment(serverUuidComment);
                configurationLoader.save((ConfigurationNode)node);
            }
        }
        this.serverUUID = node.getNode(new Object[]{"serverUuid"}).getString();
        this.logErrors = node.getNode(new Object[]{"logFailedRequests"}).getBoolean(false);
        this.logSentData = node.getNode(new Object[]{"logSentData"}).getBoolean(false);
        this.logResponseStatusText = node.getNode(new Object[]{"logResponseStatusText"}).getBoolean(false);
    }

    public void addCustomChart(CustomChart chart) {
        this.metricsBase.addCustomChart(chart);
    }

    private void appendPlatformData(JsonObjectBuilder builder) {
        builder.appendField("playerAmount", Sponge.getServer().getOnlinePlayers().size());
        builder.appendField("onlineMode", Sponge.getServer().getOnlineMode() ? 1 : 0);
        builder.appendField("minecraftVersion", Sponge.getGame().getPlatform().getMinecraftVersion().getName());
        builder.appendField("spongeImplementation", Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getName());
        builder.appendField("javaVersion", System.getProperty("java.version"));
        builder.appendField("osName", System.getProperty("os.name"));
        builder.appendField("osArch", System.getProperty("os.arch"));
        builder.appendField("osVersion", System.getProperty("os.version"));
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    private void appendServiceData(JsonObjectBuilder builder) {
        builder.appendField("pluginVersion", this.plugin.getVersion().orElse("unknown"));
    }

    public static class Factory {
        private final PluginContainer plugin;
        private final Logger logger;
        private final Path configDir;

        @Inject
        private Factory(PluginContainer plugin, Logger logger, @ConfigDir(sharedRoot=true) Path configDir) {
            this.plugin = plugin;
            this.logger = logger;
            this.configDir = configDir;
        }

        public Metrics make(int serviceId) {
            return new Metrics(this.plugin, this.logger, this.configDir, serviceId);
        }
    }
}

