/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configurate.reactive;

import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import net.skinsrestorer.shadow.configurate.reactive.MappedProcessor;
import net.skinsrestorer.shadow.configurate.reactive.ProcessorImpl;
import net.skinsrestorer.shadow.configurate.reactive.Publisher;
import net.skinsrestorer.shadow.configurate.reactive.Subscriber;
import net.skinsrestorer.shadow.configurate.reactive.TransactionFailedException;
import net.skinsrestorer.shadow.configurate.reactive.TransactionalProcessorImpl;
import net.skinsrestorer.shadow.configurate.reactive.TransactionalSubscriber;
import net.skinsrestorer.shadow.configurate.util.CheckedFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Processor<I, O>
extends Publisher<O>,
Subscriber<I> {
    public static <V> Iso<V> create() {
        return Processor.create(ForkJoinPool.commonPool());
    }

    public static <V> Iso<V> create(Executor executor) {
        return new ProcessorImpl(executor);
    }

    public static <V> TransactionalIso<V> createTransactional() {
        return Processor.createTransactional(ForkJoinPool.commonPool());
    }

    public static <V> TransactionalIso<V> createTransactional(Executor exec) {
        return new TransactionalProcessorImpl(exec);
    }

    default public <R> Processor<O, R> map(CheckedFunction<? super O, ? extends R, TransactionFailedException> mapper) {
        return new MappedProcessor<O, R>(mapper, this);
    }

    public void inject(O var1);

    public void fallbackHandler(@Nullable Subscriber<O> var1);

    public boolean closeIfUnsubscribed();

    public static interface TransactionalIso<V>
    extends Transactional<V, V>,
    Iso<V> {
    }

    public static interface Transactional<I, O>
    extends Processor<I, O>,
    Publisher<O>,
    TransactionalSubscriber<I> {
    }

    public static interface Iso<V>
    extends Processor<V, V> {
        @Override
        default public void inject(V element) {
            this.submit(element);
        }
    }
}

