/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configurate.reactive;

import com.google.errorprone.annotations.concurrent.LockMethod;
import com.google.errorprone.annotations.concurrent.UnlockMethod;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.skinsrestorer.shadow.configurate.reactive.AbstractProcessor;
import net.skinsrestorer.shadow.configurate.reactive.Subscriber;
import net.skinsrestorer.shadow.configurate.reactive.TransactionFailedException;
import net.skinsrestorer.shadow.configurate.reactive.TransactionalProcessorImpl;
import net.skinsrestorer.shadow.configurate.reactive.TransactionalSubscriber;

interface TransactionalRegistration<V>
extends AbstractProcessor.Registration<V> {
    public TransactionalProcessorImpl<V> holder();

    @Override
    default public void dispose() {
        if (this.holder().registrations.remove(this)) {
            this.holder().subscriberCount.getAndDecrement();
        }
    }

    @Override
    default public void submit(V value) {
        try {
            this.beginTransaction(value);
            this.commit();
        }
        catch (TransactionFailedException ex) {
            this.rollback();
        }
    }

    public void beginTransaction(V var1) throws TransactionFailedException;

    public void commit();

    public void rollback();

    public static class Fully<V>
    implements TransactionalRegistration<V> {
        private final TransactionalProcessorImpl<V> holder;
        private final TransactionalSubscriber<? super V> sub;
        private final Lock lock = new ReentrantLock();

        Fully(TransactionalProcessorImpl<V> holder, TransactionalSubscriber<? super V> sub) {
            this.holder = holder;
            this.sub = sub;
        }

        @Override
        public TransactionalProcessorImpl<V> holder() {
            return this.holder;
        }

        @Override
        @LockMethod(value={"lock"})
        public void beginTransaction(V value) throws TransactionFailedException {
            this.lock.lock();
            this.sub.beginTransaction(value);
        }

        @Override
        @UnlockMethod(value={"lock"})
        public void commit() {
            try {
                this.sub.commit();
            }
            finally {
                try {
                    this.lock.unlock();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {}
            }
        }

        @Override
        @UnlockMethod(value={"lock"})
        public void rollback() {
            try {
                this.sub.rollback();
            }
            finally {
                try {
                    this.lock.unlock();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {}
            }
        }

        @Override
        public void onClose() {
            this.sub.onClose();
        }

        @Override
        public void onError(Throwable e) {
            this.sub.onError(e);
        }
    }

    public static class Wrapped<V>
    implements TransactionalRegistration<V> {
        private final AtomicReference<V> active = new AtomicReference();
        private final TransactionalProcessorImpl<V> holder;
        private final Subscriber<? super V> sub;

        Wrapped(TransactionalProcessorImpl<V> holder, Subscriber<? super V> sub) {
            this.holder = holder;
            this.sub = sub;
        }

        @Override
        public TransactionalProcessorImpl<V> holder() {
            return this.holder;
        }

        @Override
        public void beginTransaction(V value) {
            this.active.set(value);
        }

        @Override
        public void commit() {
            Object active = this.active.getAndSet(null);
            if (active != null) {
                this.sub.submit(active);
            }
        }

        @Override
        public void rollback() {
            this.active.set(null);
        }

        @Override
        public void onClose() {
            this.sub.onClose();
        }

        @Override
        public void onError(Throwable e) {
            this.sub.onError(e);
        }
    }
}

