/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configurate.reference;

import java.util.concurrent.Executor;
import java.util.function.Function;
import net.skinsrestorer.shadow.configurate.ConfigurateException;
import net.skinsrestorer.shadow.configurate.ConfigurationNode;
import net.skinsrestorer.shadow.configurate.NodePath;
import net.skinsrestorer.shadow.configurate.ScopedConfigurationNode;
import net.skinsrestorer.shadow.configurate.reactive.Disposable;
import net.skinsrestorer.shadow.configurate.reactive.Publisher;
import net.skinsrestorer.shadow.configurate.reactive.Subscriber;
import net.skinsrestorer.shadow.configurate.reactive.TransactionFailedException;
import net.skinsrestorer.shadow.configurate.reference.ConfigurationReference;
import net.skinsrestorer.shadow.configurate.reference.ManualConfigurationReference;
import net.skinsrestorer.shadow.configurate.reference.ValueReference;
import net.skinsrestorer.shadow.configurate.serialize.SerializationException;
import net.skinsrestorer.shadow.configurate.serialize.TypeSerializer;
import net.skinsrestorer.shadow.configurate.util.UnmodifiableCollections;
import net.skinsrestorer.shadow.geantyref.TypeToken;
import org.checkerframework.checker.nullness.qual.Nullable;

class ValueReferenceImpl<@Nullable T, N extends ScopedConfigurationNode<N>>
implements ValueReference<T, N>,
Publisher<T> {
    private final ManualConfigurationReference<N> root;
    private final NodePath path;
    private final TypeToken<T> type;
    private final TypeSerializer<T> serializer;
    private final Publisher.Cached<@Nullable T> deserialized;

    ValueReferenceImpl(ManualConfigurationReference<N> root, NodePath path, TypeToken<T> type, @Nullable T def) throws SerializationException {
        this.root = root;
        this.path = path;
        this.type = type;
        @Nullable TypeSerializer<T> serializer = root.node().options().serializers().get(type);
        if (serializer == null) {
            throw new SerializationException(this.path, type.getType(), "Unsupported type" + type);
        }
        this.serializer = serializer;
        this.deserialized = root.updateListener.map((I n) -> {
            try {
                return this.deserializedValueFrom(n, def);
            }
            catch (SerializationException e) {
                root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.VALUE, e));
                throw new TransactionFailedException(e);
            }
        }).cache(this.deserializedValueFrom(root.node(), def));
    }

    ValueReferenceImpl(ManualConfigurationReference<N> root, NodePath path, Class<T> type, @Nullable T def) throws SerializationException {
        this(root, path, TypeToken.get(type), def);
    }

    private @Nullable T deserializedValueFrom(N parent, @Nullable T defaultVal) throws SerializationException {
        T defaultOrEmpty;
        ConfigurationNode node = parent.node((Iterable)this.path);
        if (!node.virtual()) {
            return this.serializer.deserialize(this.type.getType(), node);
        }
        T t = defaultOrEmpty = defaultVal == null ? this.serializer.emptyValue(this.type.getType(), node.options()) : defaultVal;
        if (node.options().shouldCopyDefaults()) {
            this.serializer.serialize(this.type.getType(), defaultOrEmpty, node);
        }
        return defaultOrEmpty;
    }

    @Override
    public @Nullable T get() {
        return this.deserialized.get();
    }

    @Override
    public boolean set(@Nullable T value) {
        try {
            this.serializer.serialize(this.type.getType(), value, this.node());
            this.deserialized.submit(value);
            return true;
        }
        catch (SerializationException e) {
            this.root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.SAVING, e));
            return false;
        }
    }

    @Override
    public boolean setAndSave(@Nullable T value) {
        try {
            if (this.set(value)) {
                this.root.save();
                return true;
            }
        }
        catch (ConfigurateException e) {
            this.root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.SAVING, e));
        }
        return false;
    }

    @Override
    public Publisher<Boolean> setAndSaveAsync(@Nullable T value) {
        return Publisher.execute(() -> {
            this.serializer.serialize(this.type.getType(), value, this.node());
            this.deserialized.submit(value);
            this.root.save();
            return true;
        }, this.root.updates().executor());
    }

    @Override
    public boolean update(Function<@Nullable T, ? extends T> action) {
        try {
            return this.set(action.apply(this.get()));
        }
        catch (Exception t) {
            this.root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.VALUE, t));
            return false;
        }
    }

    @Override
    public Publisher<Boolean> updateAsync(Function<@Nullable T, ? extends T> action) {
        return Publisher.execute(() -> {
            @Nullable T orig = this.get();
            Object updated = action.apply(orig);
            this.serializer.serialize(this.type.getType(), updated, this.node());
            this.deserialized.submit(updated);
            this.root.save();
            return true;
        }, this.root.updates().executor());
    }

    @Override
    public N node() {
        return (N)this.root.node().node((Iterable)this.path);
    }

    @Override
    public Disposable subscribe(Subscriber<? super T> subscriber) {
        return this.deserialized.subscribe(subscriber);
    }

    @Override
    public boolean hasSubscribers() {
        return this.deserialized.hasSubscribers();
    }

    @Override
    public Executor executor() {
        return this.deserialized.executor();
    }
}

