/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configurate.serialize;

import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.skinsrestorer.shadow.configurate.serialize.ScalarSerializer;
import net.skinsrestorer.shadow.configurate.serialize.SerializationException;
import net.skinsrestorer.shadow.configurate.util.CheckedFunction;

final class FunctionScalarSerializer<T>
extends ScalarSerializer<T> {
    private final CheckedFunction<Object, T, SerializationException> deserializer;
    private final BiFunction<T, Predicate<Class<?>>, Object> serializer;

    FunctionScalarSerializer(Type type, CheckedFunction<Object, T, SerializationException> deserializer, BiFunction<T, Predicate<Class<?>>, Object> serializer) {
        super(type);
        this.deserializer = deserializer;
        this.serializer = serializer;
    }

    @Override
    public T deserialize(Type type, Object obj) throws SerializationException {
        try {
            return this.deserializer.apply(obj);
        }
        catch (SerializationException ex) {
            ex.initType(type);
            throw ex;
        }
    }

    @Override
    public Object serialize(T item, Predicate<Class<?>> typeSupported) {
        return this.serializer.apply(item, typeSupported);
    }
}

