/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.gson.internal.bind;

import java.io.IOException;
import net.skinsrestorer.shadow.gson.Gson;
import net.skinsrestorer.shadow.gson.JsonSyntaxException;
import net.skinsrestorer.shadow.gson.ToNumberPolicy;
import net.skinsrestorer.shadow.gson.ToNumberStrategy;
import net.skinsrestorer.shadow.gson.TypeAdapter;
import net.skinsrestorer.shadow.gson.TypeAdapterFactory;
import net.skinsrestorer.shadow.gson.reflect.TypeToken;
import net.skinsrestorer.shadow.gson.stream.JsonReader;
import net.skinsrestorer.shadow.gson.stream.JsonToken;
import net.skinsrestorer.shadow.gson.stream.JsonWriter;

public final class NumberTypeAdapter
extends TypeAdapter<Number> {
    private static final TypeAdapterFactory LAZILY_PARSED_NUMBER_FACTORY = NumberTypeAdapter.newFactory(ToNumberPolicy.LAZILY_PARSED_NUMBER);
    private final ToNumberStrategy toNumberStrategy;

    private NumberTypeAdapter(ToNumberStrategy toNumberStrategy) {
        this.toNumberStrategy = toNumberStrategy;
    }

    private static TypeAdapterFactory newFactory(ToNumberStrategy toNumberStrategy) {
        NumberTypeAdapter adapter = new NumberTypeAdapter(toNumberStrategy);
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                return type.getRawType() == Number.class ? NumberTypeAdapter.this : null;
            }
        };
    }

    public static TypeAdapterFactory getFactory(ToNumberStrategy toNumberStrategy) {
        if (toNumberStrategy == ToNumberPolicy.LAZILY_PARSED_NUMBER) {
            return LAZILY_PARSED_NUMBER_FACTORY;
        }
        return NumberTypeAdapter.newFactory(toNumberStrategy);
    }

    @Override
    public Number read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        switch (jsonToken) {
            case NULL: {
                in.nextNull();
                return null;
            }
            case NUMBER: 
            case STRING: {
                return this.toNumberStrategy.readNumber(in);
            }
        }
        throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken));
    }

    @Override
    public void write(JsonWriter out, Number value) throws IOException {
        out.value(value);
    }
}

