/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import net.skinsrestorer.shadow.mariadb.MariaDbConnection;
import net.skinsrestorer.shadow.mariadb.UrlParser;
import net.skinsrestorer.shadow.mariadb.internal.util.DeRegister;
import net.skinsrestorer.shadow.mariadb.internal.util.constant.HaMode;
import net.skinsrestorer.shadow.mariadb.internal.util.constant.Version;
import net.skinsrestorer.shadow.mariadb.util.DefaultOptions;
import net.skinsrestorer.shadow.mariadb.util.Options;

public final class Driver
implements java.sql.Driver {
    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        UrlParser urlParser = UrlParser.parse(url, props);
        if (urlParser == null || urlParser.getHostAddresses() == null) {
            return null;
        }
        return MariaDbConnection.newConnection(urlParser, null);
    }

    @Override
    public boolean acceptsURL(String url) {
        return UrlParser.acceptsUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Options options;
        if (url != null && !url.isEmpty()) {
            UrlParser urlParser = UrlParser.parse(url, info);
            if (urlParser == null || urlParser.getOptions() == null) {
                return new DriverPropertyInfo[0];
            }
            options = urlParser.getOptions();
        } else {
            options = DefaultOptions.parse(HaMode.NONE, "", info, null);
        }
        ArrayList<DriverPropertyInfo> props = new ArrayList<DriverPropertyInfo>();
        for (DefaultOptions o : DefaultOptions.values()) {
            try {
                Field field = Options.class.getField(o.getOptionName());
                Object value = field.get(options);
                DriverPropertyInfo propertyInfo = new DriverPropertyInfo(field.getName(), value == null ? null : value.toString());
                propertyInfo.description = o.getDescription();
                propertyInfo.required = o.isRequired();
                props.add(propertyInfo);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return props.toArray(new DriverPropertyInfo[props.size()]);
    }

    @Override
    public int getMajorVersion() {
        return Version.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return Version.minorVersion;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Use logging parameters for enabling logging.");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver(), new DeRegister());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not register driver", e);
        }
    }
}

