/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.skinsrestorer.shadow.mariadb.internal.logging.Logger;
import net.skinsrestorer.shadow.mariadb.internal.logging.LoggerFactory;
import net.skinsrestorer.shadow.mariadb.internal.util.constant.HaMode;

public class HostAddress {
    private static final Logger logger = LoggerFactory.getLogger(HostAddress.class);
    public String host;
    public int port;
    public String type = null;

    private HostAddress() {
    }

    public HostAddress(String host, int port) {
        this.host = host;
        this.port = port;
        this.type = "master";
    }

    public HostAddress(String host, int port, String type) {
        this.host = host;
        this.port = port;
        this.type = type;
    }

    public static List<HostAddress> parse(String spec, HaMode haMode) {
        Object clusterPattern;
        Matcher matcher;
        if (spec == null) {
            throw new IllegalArgumentException("Invalid connection URL, host address must not be empty ");
        }
        if ("".equals(spec)) {
            return new ArrayList<HostAddress>(0);
        }
        String[] tokens = spec.trim().split(",");
        int size = tokens.length;
        ArrayList<HostAddress> arr = new ArrayList<HostAddress>(size);
        if (haMode == HaMode.AURORA && !(matcher = ((Pattern)(clusterPattern = Pattern.compile("(.+)\\.(?:cluster-|cluster-ro-|cluster-custom-)([a-z0-9]+\\.[a-z0-9\\-]+\\.rds\\.amazonaws\\.com)", 2))).matcher(spec)).find()) {
            logger.warn("Aurora recommended connection URL must only use cluster end-point like \"jdbc:mariadb:aurora://xx.cluster-yy.zz.rds.amazonaws.com\". Using end-point permit auto-discovery of new replicas");
        }
        for (String token : tokens) {
            if (token.startsWith("address=")) {
                arr.add(HostAddress.parseParameterHostAddress(token));
                continue;
            }
            arr.add(HostAddress.parseSimpleHostAddress(token));
        }
        if (haMode == HaMode.REPLICATION) {
            for (int i = 0; i < size; ++i) {
                if (i == 0 && ((HostAddress)arr.get((int)i)).type == null) {
                    ((HostAddress)arr.get((int)i)).type = "master";
                    continue;
                }
                if (i == 0 || ((HostAddress)arr.get((int)i)).type != null) continue;
                ((HostAddress)arr.get((int)i)).type = "replica";
            }
        }
        return arr;
    }

    private static HostAddress parseSimpleHostAddress(String str) {
        HostAddress result = new HostAddress();
        if (str.charAt(0) == '[') {
            int ind = str.indexOf(93);
            result.host = str.substring(1, ind);
            if (ind != str.length() - 1 && str.charAt(ind + 1) == ':') {
                result.port = HostAddress.getPort(str.substring(ind + 2));
            }
        } else if (str.contains(":")) {
            String[] hostPort = str.split(":");
            result.host = hostPort[0];
            result.port = HostAddress.getPort(hostPort[1]);
        } else {
            result.host = str;
            result.port = 3306;
        }
        return result;
    }

    private static int getPort(String portString) {
        try {
            return Integer.parseInt(portString);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Incorrect port value : " + portString);
        }
    }

    private static HostAddress parseParameterHostAddress(String str) {
        HostAddress result = new HostAddress();
        String[] array = str.split("(?=\\()|(?<=\\))");
        for (int i = 1; i < array.length; ++i) {
            String[] token = array[i].replace("(", "").replace(")", "").trim().split("=");
            if (token.length != 2) {
                throw new IllegalArgumentException("Invalid connection URL, expected key=value pairs, found " + array[i]);
            }
            String key = token[0].toLowerCase();
            String value = token[1].toLowerCase();
            if ("host".equals(key)) {
                result.host = value.replace("[", "").replace("]", "");
                continue;
            }
            if ("port".equals(key)) {
                result.port = HostAddress.getPort(value);
                continue;
            }
            if (!"type".equals(key)) continue;
            if (value.equals("master") || value.equals("replica")) {
                result.type = value;
                continue;
            }
            if (!"slave".equals(value)) continue;
            result.type = "replica";
        }
        return result;
    }

    public static String toString(List<HostAddress> addrs) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < addrs.size(); ++i) {
            if (addrs.get((int)i).type != null) {
                str.append("address=(host=").append(addrs.get((int)i).host).append(")(port=").append(addrs.get((int)i).port).append(")(type=").append(addrs.get((int)i).type).append(")");
            } else {
                boolean isIPv6 = addrs.get((int)i).host != null && addrs.get((int)i).host.contains(":");
                String host = isIPv6 ? "[" + addrs.get((int)i).host + "]" : addrs.get((int)i).host;
                str.append(host).append(":").append(addrs.get((int)i).port);
            }
            if (i >= addrs.size() - 1) continue;
            str.append(",");
        }
        return str.toString();
    }

    public static String toString(HostAddress[] addrs) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < addrs.length; ++i) {
            if (addrs[i].type != null) {
                str.append("address=(host=").append(addrs[i].host).append(")(port=").append(addrs[i].port).append(")(type=").append(addrs[i].type).append(")");
            } else {
                boolean isIPv6 = addrs[i].host != null && addrs[i].host.contains(":");
                String host = isIPv6 ? "[" + addrs[i].host + "]" : addrs[i].host;
                str.append(host).append(":").append(addrs[i].port);
            }
            if (i >= addrs.length - 1) continue;
            str.append(",");
        }
        return str.toString();
    }

    public String toString() {
        return "HostAddress{host='" + this.host + '\'' + ", port=" + this.port + (this.type != null ? ", type='" + this.type + "'" : "") + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HostAddress that = (HostAddress)obj;
        return this.port == that.port && (this.host != null ? this.host.equals(that.host) : that.host == null && !(this.type == null ? that.type != null : !this.type.equals(that.type)));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }
}

