/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.skinsrestorer.shadow.mariadb.BasePrepareStatement;
import net.skinsrestorer.shadow.mariadb.MariaDbConnection;
import net.skinsrestorer.shadow.mariadb.MariaDbParameterMetaData;
import net.skinsrestorer.shadow.mariadb.MariaDbResultSetMetaData;
import net.skinsrestorer.shadow.mariadb.internal.com.read.dao.Results;
import net.skinsrestorer.shadow.mariadb.internal.com.read.resultset.SelectResultSet;
import net.skinsrestorer.shadow.mariadb.internal.com.send.parameters.ParameterHolder;
import net.skinsrestorer.shadow.mariadb.internal.logging.Logger;
import net.skinsrestorer.shadow.mariadb.internal.logging.LoggerFactory;
import net.skinsrestorer.shadow.mariadb.internal.util.dao.ServerPrepareResult;
import net.skinsrestorer.shadow.mariadb.internal.util.exceptions.ExceptionFactory;

public class ServerSidePreparedStatement
extends BasePrepareStatement
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(ServerSidePreparedStatement.class);
    protected int parameterCount = -1;
    private String sql;
    private ServerPrepareResult serverPrepareResult = null;
    private MariaDbResultSetMetaData metadata;
    private MariaDbParameterMetaData parameterMetaData;
    private Map<Integer, ParameterHolder> currentParameterHolder;
    private List<ParameterHolder[]> queryParameters = new ArrayList<ParameterHolder[]>();
    private boolean mustExecuteOnMaster;

    public ServerSidePreparedStatement(MariaDbConnection connection, String sql, int resultSetScrollType, int resultSetConcurrency, int autoGeneratedKeys, ExceptionFactory exceptionFactory) throws SQLException {
        super(connection, resultSetScrollType, resultSetConcurrency, autoGeneratedKeys, exceptionFactory);
        this.sql = sql;
        this.currentParameterHolder = Collections.synchronizedMap(new TreeMap());
        this.mustExecuteOnMaster = this.protocol.isMasterConnection();
        this.prepare(this.sql);
    }

    @Override
    public ServerSidePreparedStatement clone(MariaDbConnection connection) throws CloneNotSupportedException {
        ServerSidePreparedStatement clone = (ServerSidePreparedStatement)super.clone(connection);
        clone.metadata = this.metadata;
        clone.parameterMetaData = this.parameterMetaData;
        clone.queryParameters = new ArrayList<ParameterHolder[]>();
        clone.mustExecuteOnMaster = this.mustExecuteOnMaster;
        try {
            clone.prepare(this.sql);
        }
        catch (SQLException e) {
            throw new CloneNotSupportedException("PrepareStatement not ");
        }
        return clone;
    }

    private void prepare(String sql) throws SQLException {
        try {
            this.serverPrepareResult = this.protocol.prepare(sql, this.mustExecuteOnMaster);
            this.setMetaFromResult();
        }
        catch (SQLException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.error("error preparing query", e);
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create(e);
        }
    }

    private void setMetaFromResult() {
        this.parameterCount = this.serverPrepareResult.getParameters().length;
        this.metadata = new MariaDbResultSetMetaData(this.serverPrepareResult.getColumns(), this.protocol.getUrlParser().getOptions(), false);
        this.parameterMetaData = new MariaDbParameterMetaData(this.serverPrepareResult.getParameters());
    }

    @Override
    public void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        this.currentParameterHolder.put(parameterIndex - 1, holder);
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        this.queryParameters.add(this.currentParameterHolder.values().toArray(new ParameterHolder[0]));
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Cannot do addBatch(String) on preparedStatement");
    }

    @Override
    public void clearBatch() {
        this.queryParameters.clear();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.parameterMetaData;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        int queryParameterSize = this.queryParameters.size();
        if (queryParameterSize == 0) {
            return new int[0];
        }
        this.executeBatchInternal(queryParameterSize);
        return this.results.getCmdInformation().getUpdateCounts();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkClose();
        int queryParameterSize = this.queryParameters.size();
        if (queryParameterSize == 0) {
            return new long[0];
        }
        this.executeBatchInternal(queryParameterSize);
        return this.results.getCmdInformation().getLargeUpdateCounts();
    }

    private void executeBatchInternal(int queryParameterSize) throws SQLException {
        this.lock.lock();
        this.executing = true;
        try {
            this.executeQueryPrologue(this.serverPrepareResult);
            if (this.queryTimeout != 0) {
                this.setTimerTask(true);
            }
            this.results = new Results(this, 0, true, queryParameterSize, true, this.resultSetScrollType, this.resultSetConcurrency, this.autoGeneratedKeys, this.protocol.getAutoIncrementIncrement(), null, null);
            if ((this.options.useBatchMultiSend.booleanValue() || this.options.useBulkStmts) && this.protocol.executeBatchServer(this.mustExecuteOnMaster, this.serverPrepareResult, this.results, this.sql, this.queryParameters)) {
                if (this.metadata == null) {
                    this.setMetaFromResult();
                }
                this.results.commandEnd();
                return;
            }
            SQLException exception = null;
            if (this.queryTimeout > 0) {
                for (int counter = 0; counter < queryParameterSize; ++counter) {
                    ParameterHolder[] parameterHolder = this.queryParameters.get(counter);
                    try {
                        this.protocol.stopIfInterrupted();
                        this.serverPrepareResult.resetParameterTypeHeader();
                        this.protocol.executePreparedQuery(this.mustExecuteOnMaster, this.serverPrepareResult, this.results, parameterHolder);
                        continue;
                    }
                    catch (SQLException queryException) {
                        if (this.options.continueBatchOnError && this.protocol.isConnected() && !this.protocol.isInterrupted()) {
                            if (exception != null) continue;
                            exception = queryException;
                            continue;
                        }
                        throw queryException;
                    }
                }
            } else {
                for (int counter = 0; counter < queryParameterSize; ++counter) {
                    ParameterHolder[] parameterHolder = this.queryParameters.get(counter);
                    try {
                        this.serverPrepareResult.resetParameterTypeHeader();
                        this.protocol.executePreparedQuery(this.mustExecuteOnMaster, this.serverPrepareResult, this.results, parameterHolder);
                        continue;
                    }
                    catch (SQLException queryException) {
                        if (this.options.continueBatchOnError) {
                            if (exception != null) continue;
                            exception = queryException;
                            continue;
                        }
                        throw queryException;
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
            this.results.commandEnd();
        }
        catch (SQLException initialSqlEx) {
            throw this.executeBatchExceptionEpilogue(initialSqlEx, queryParameterSize);
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    private void executeQueryPrologue(ServerPrepareResult serverPrepareResult) throws SQLException {
        this.executing = true;
        if (this.closed) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("execute() is called on closed statement");
        }
        this.protocol.prologProxy(serverPrepareResult, this.maxRows, this.protocol.getProxy() != null, this.connection, this);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.execute()) {
            return this.results.getResultSet();
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public void clearParameters() {
        this.currentParameterHolder.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal(this.getFetchSize());
    }

    protected void validParameters() throws SQLException {
        for (int i = 0; i < this.parameterCount; ++i) {
            if (this.currentParameterHolder.get(i) != null) continue;
            logger.error("Parameter at position {} is not set", (Object)(i + 1));
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Parameter at position " + (i + 1) + " is not set", "07004");
        }
    }

    @Override
    protected boolean executeInternal(int fetchSize) throws SQLException {
        this.validParameters();
        this.lock.lock();
        try {
            this.executeQueryPrologue(this.serverPrepareResult);
            if (this.queryTimeout != 0) {
                this.setTimerTask(false);
            }
            ParameterHolder[] parameterHolders = this.currentParameterHolder.values().toArray(new ParameterHolder[0]);
            this.results = new Results(this, fetchSize, false, 1, true, this.resultSetScrollType, this.resultSetConcurrency, this.autoGeneratedKeys, this.protocol.getAutoIncrementIncrement(), this.sql, parameterHolders);
            this.serverPrepareResult.resetParameterTypeHeader();
            this.protocol.executePreparedQuery(this.mustExecuteOnMaster, this.serverPrepareResult, this.results, parameterHolders);
            this.results.commandEnd();
            boolean bl = this.results.getResultSet() != null;
            return bl;
        }
        catch (SQLException exception) {
            throw this.executeExceptionEpilogue(exception);
        }
        finally {
            this.executeEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.protocol != null && this.serverPrepareResult != null) {
            try {
                this.serverPrepareResult.getUnProxiedProtocol().releasePrepareStatement(this.serverPrepareResult);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.close();
    }

    protected int getParameterCount() {
        return this.parameterCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("sql : '" + this.serverPrepareResult.getSql() + "'");
        if (this.parameterCount > 0) {
            sb.append(", parameters : [");
            for (int i = 0; i < this.parameterCount; ++i) {
                ParameterHolder holder = this.currentParameterHolder.get(i);
                if (holder == null) {
                    sb.append("null");
                } else {
                    sb.append(holder.toString());
                }
                if (i == this.parameterCount - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public long getServerThreadId() {
        return this.serverPrepareResult.getUnProxiedProtocol().getServerThreadId();
    }
}

