/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.internal.com.read.dao;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.skinsrestorer.shadow.mariadb.internal.com.read.resultset.ColumnDefinition;
import net.skinsrestorer.shadow.mariadb.internal.util.exceptions.ExceptionFactory;

public class ColumnLabelIndexer {
    private final ColumnDefinition[] columnInfo;
    private Map<String, Integer> originalMap;
    private Map<String, Integer> aliasMap;

    public ColumnLabelIndexer(ColumnDefinition[] columnDefinitions) {
        this.columnInfo = columnDefinitions;
    }

    public int getIndex(String name) throws SQLException {
        Integer res;
        if (name == null) {
            throw new SQLException("Column name cannot be null");
        }
        String lowerName = name.toLowerCase(Locale.ROOT);
        if (this.aliasMap == null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnDefinition ci : this.columnInfo) {
                String columnAlias = ci.getName();
                if (columnAlias != null) {
                    columnAlias = columnAlias.toLowerCase(Locale.ROOT);
                    map.putIfAbsent(columnAlias, counter);
                    String tableName = ci.getTable();
                    if (tableName != null) {
                        map.putIfAbsent(tableName.toLowerCase(Locale.ROOT) + "." + columnAlias, counter);
                    }
                }
                ++counter;
            }
            this.aliasMap = map;
        }
        if ((res = this.aliasMap.get(lowerName)) != null) {
            return res;
        }
        if (this.originalMap == null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnDefinition ci : this.columnInfo) {
                String columnRealName = ci.getOriginalName();
                if (columnRealName != null) {
                    columnRealName = columnRealName.toLowerCase(Locale.ROOT);
                    map.putIfAbsent(columnRealName, counter);
                    String tableName = ci.getOriginalTable();
                    if (tableName != null) {
                        map.putIfAbsent(tableName.toLowerCase(Locale.ROOT) + "." + columnRealName, counter);
                    }
                }
                ++counter;
            }
            this.originalMap = map;
        }
        if ((res = this.originalMap.get(lowerName)) == null) {
            HashMap<String, Integer> possible = new HashMap<String, Integer>();
            possible.putAll(this.aliasMap);
            possible.putAll(this.originalMap);
            throw ExceptionFactory.INSTANCE.create(String.format("No such column: '%s'. '%s' must be in %s", name, lowerName, possible.keySet().toString()), "42S22", 1054);
        }
        return res;
    }
}

