/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.internal.com.send;

import java.io.IOException;
import java.sql.SQLException;
import net.skinsrestorer.shadow.mariadb.internal.com.read.Buffer;
import net.skinsrestorer.shadow.mariadb.internal.com.read.ErrorPacket;
import net.skinsrestorer.shadow.mariadb.internal.com.read.resultset.ColumnDefinition;
import net.skinsrestorer.shadow.mariadb.internal.io.input.PacketInputStream;
import net.skinsrestorer.shadow.mariadb.internal.io.output.PacketOutputStream;
import net.skinsrestorer.shadow.mariadb.internal.protocol.Protocol;
import net.skinsrestorer.shadow.mariadb.internal.util.dao.ServerPrepareResult;

public class ComStmtPrepare {
    private final Protocol protocol;
    private final String sql;

    public ComStmtPrepare(Protocol protocol, String sql) {
        this.protocol = protocol;
        this.sql = sql;
    }

    public ComStmtPrepare send(PacketOutputStream pos) throws IOException {
        pos.startPacket(0);
        pos.write(22);
        pos.write(this.sql);
        pos.flush();
        return this;
    }

    public ServerPrepareResult read(PacketInputStream reader, boolean eofDeprecated) throws IOException, SQLException {
        Buffer buffer = reader.getPacket(true);
        byte firstByte = buffer.getByteAt(buffer.position);
        if (firstByte == -1) {
            throw this.buildErrorException(buffer);
        }
        if (firstByte == 0) {
            int i;
            buffer.readByte();
            int statementId = buffer.readInt();
            int numColumns = buffer.readShort() & 0xFFFF;
            int numParams = buffer.readShort() & 0xFFFF;
            ColumnDefinition[] params = new ColumnDefinition[numParams];
            ColumnDefinition[] columns = new ColumnDefinition[numColumns];
            if (numParams > 0) {
                for (i = 0; i < numParams; ++i) {
                    params[i] = new ColumnDefinition(reader.getPacket(false));
                }
                if (numColumns > 0) {
                    if (!eofDeprecated) {
                        this.protocol.skipEofPacket();
                    }
                    for (i = 0; i < numColumns; ++i) {
                        columns[i] = new ColumnDefinition(reader.getPacket(false));
                    }
                }
                if (!eofDeprecated) {
                    this.protocol.readEofPacket();
                }
            } else if (numColumns > 0) {
                for (i = 0; i < numColumns; ++i) {
                    columns[i] = new ColumnDefinition(reader.getPacket(false));
                }
                if (!eofDeprecated) {
                    this.protocol.readEofPacket();
                }
            } else {
                buffer.readByte();
                this.protocol.setHasWarnings(buffer.readShort() > 0);
            }
            ServerPrepareResult serverPrepareResult = new ServerPrepareResult(this.sql, statementId, columns, params, this.protocol);
            if (this.protocol.getOptions().cachePrepStmts && this.protocol.getOptions().useServerPrepStmts && this.sql != null && this.sql.length() < this.protocol.getOptions().prepStmtCacheSqlLimit) {
                String key = this.protocol.getDatabase() + "-" + this.sql;
                ServerPrepareResult cachedServerPrepareResult = this.protocol.putInCache(key, serverPrepareResult);
                return cachedServerPrepareResult != null ? cachedServerPrepareResult : serverPrepareResult;
            }
            return serverPrepareResult;
        }
        throw new SQLException("Unexpected packet returned by server, first byte " + firstByte);
    }

    private SQLException buildErrorException(Buffer buffer) {
        ErrorPacket ep = new ErrorPacket(buffer);
        String message = ep.getMessage();
        if (1054 == ep.getErrorCode()) {
            return new SQLException(message + "\nIf column exists but type cannot be identified (example 'select ? `field1` from dual'). Use CAST function to solve this problem (example 'select CAST(? as integer) `field1` from dual')", ep.getSqlState(), ep.getErrorCode());
        }
        return new SQLException(message, ep.getSqlState(), ep.getErrorCode());
    }
}

