/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.internal.com.send;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import net.skinsrestorer.shadow.mariadb.credential.Credential;
import net.skinsrestorer.shadow.mariadb.internal.com.read.Buffer;
import net.skinsrestorer.shadow.mariadb.internal.io.output.PacketOutputStream;
import net.skinsrestorer.shadow.mariadb.internal.util.Utils;
import net.skinsrestorer.shadow.mariadb.internal.util.constant.Version;
import net.skinsrestorer.shadow.mariadb.internal.util.pid.PidFactory;
import net.skinsrestorer.shadow.mariadb.util.Options;

public class SendHandshakeResponsePacket {
    private static final Supplier<String> pidRequest = PidFactory.getInstance();
    private static final byte[] _CLIENT_NAME = "_client_name".getBytes();
    private static final byte[] _CLIENT_VERSION = "_client_version".getBytes();
    private static final byte[] _SERVER_HOST = "_server_host".getBytes();
    private static final byte[] _OS = "_os".getBytes();
    private static final byte[] _PID = "_pid".getBytes();
    private static final byte[] _THREAD = "_thread".getBytes();
    private static final byte[] _JAVA_VENDOR = "_java_vendor".getBytes();
    private static final byte[] _JAVA_VERSION = "_java_version".getBytes();

    public static void send(PacketOutputStream pos, Credential credential, String host, String database, long clientCapabilities, long serverCapabilities, byte serverLanguage, byte packetSeq, Options options, String authenticationPluginType, byte[] seed) throws IOException {
        byte[] authData;
        pos.startPacket(packetSeq);
        switch (authenticationPluginType) {
            case "mysql_clear_password": {
                pos.permitTrace(false);
                if (credential.getPassword() == null) {
                    authData = new byte[]{};
                    break;
                }
                if (options.passwordCharacterEncoding != null && !options.passwordCharacterEncoding.isEmpty()) {
                    authData = credential.getPassword().getBytes(options.passwordCharacterEncoding);
                    break;
                }
                authData = credential.getPassword().getBytes();
                break;
            }
            default: {
                authenticationPluginType = "mysql_native_password";
                pos.permitTrace(false);
                try {
                    authData = Utils.encryptPassword(credential.getPassword(), seed, options.passwordCharacterEncoding);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("Unknown algorithm SHA-1. Cannot encrypt password", e);
                }
            }
        }
        pos.writeInt((int)clientCapabilities);
        pos.writeInt(0x40000000);
        pos.write(serverLanguage);
        pos.writeBytes((byte)0, 19);
        pos.writeInt((int)(clientCapabilities >> 32));
        if (credential.getUser() == null || credential.getUser().isEmpty()) {
            pos.write(System.getProperty("user.name").getBytes());
        } else {
            pos.write(credential.getUser().getBytes());
        }
        pos.write(0);
        if ((serverCapabilities & 0x200000L) != 0L) {
            pos.writeFieldLength(authData.length);
            pos.write(authData);
        } else if ((serverCapabilities & 0x8000L) != 0L) {
            pos.write((byte)authData.length);
            pos.write(authData);
        } else {
            pos.write(authData);
            pos.write(0);
        }
        if ((clientCapabilities & 8L) != 0L) {
            pos.write(database);
            pos.write(0);
        }
        if ((serverCapabilities & 0x80000L) != 0L) {
            pos.write(authenticationPluginType);
            pos.write(0);
        }
        if ((serverCapabilities & 0x100000L) != 0L) {
            SendHandshakeResponsePacket.writeConnectAttributes(pos, options.connectionAttributes, host);
        }
        pos.flush();
        pos.permitTrace(true);
    }

    private static void writeConnectAttributes(PacketOutputStream pos, String connectionAttributes, String host) throws IOException {
        Buffer buffer = new Buffer(new byte[200]);
        buffer.writeStringSmallLength(_CLIENT_NAME);
        buffer.writeStringLength("MariaDB Connector/J");
        buffer.writeStringSmallLength(_CLIENT_VERSION);
        buffer.writeStringLength(Version.version);
        buffer.writeStringSmallLength(_SERVER_HOST);
        buffer.writeStringLength(host != null ? host : "");
        buffer.writeStringSmallLength(_OS);
        buffer.writeStringLength(System.getProperty("os.name"));
        String pid = pidRequest.get();
        if (pid != null) {
            buffer.writeStringSmallLength(_PID);
            buffer.writeStringLength(pid);
        }
        buffer.writeStringSmallLength(_THREAD);
        buffer.writeStringLength(Long.toString(Thread.currentThread().getId()));
        buffer.writeStringLength(_JAVA_VENDOR);
        buffer.writeStringLength(System.getProperty("java.vendor"));
        buffer.writeStringSmallLength(_JAVA_VERSION);
        buffer.writeStringLength(System.getProperty("java.version"));
        if (connectionAttributes != null) {
            StringTokenizer tokenizer = new StringTokenizer(connectionAttributes, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int separator = token.indexOf(":");
                if (separator != -1) {
                    buffer.writeStringLength(token.substring(0, separator));
                    buffer.writeStringLength(token.substring(separator + 1));
                    continue;
                }
                buffer.writeStringLength(token);
                buffer.writeStringLength("");
            }
        }
        pos.writeFieldLength(buffer.position);
        pos.write(buffer.buf, 0, buffer.position);
    }
}

