/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.internal.com.send.parameters;

import java.io.IOException;
import java.math.BigDecimal;
import net.skinsrestorer.shadow.mariadb.internal.ColumnType;
import net.skinsrestorer.shadow.mariadb.internal.com.send.parameters.ParameterHolder;
import net.skinsrestorer.shadow.mariadb.internal.io.output.PacketOutputStream;

public class BigDecimalParameter
implements Cloneable,
ParameterHolder {
    private final BigDecimal bigDecimal;

    public BigDecimalParameter(BigDecimal bigDecimal) {
        this.bigDecimal = bigDecimal;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(this.bigDecimal.toPlainString().getBytes());
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return this.bigDecimal.toPlainString().getBytes().length;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        String value = this.bigDecimal.toPlainString();
        pos.writeFieldLength(value.length());
        pos.write(value);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.DECIMAL;
    }

    @Override
    public String toString() {
        return this.bigDecimal.toString();
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean canBeLongData() {
        return false;
    }
}

