/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.internal.com.send.parameters;

import java.io.IOException;
import java.util.Arrays;
import net.skinsrestorer.shadow.mariadb.internal.ColumnType;
import net.skinsrestorer.shadow.mariadb.internal.com.send.parameters.ParameterHolder;
import net.skinsrestorer.shadow.mariadb.internal.io.output.PacketOutputStream;

public class ByteArrayParameter
implements Cloneable,
ParameterHolder {
    private final byte[] bytes;
    private final boolean noBackslashEscapes;

    public ByteArrayParameter(byte[] bytes, boolean noBackslashEscapes) {
        this.bytes = bytes;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(BINARY_INTRODUCER);
        pos.writeBytesEscaped(this.bytes, this.bytes.length, this.noBackslashEscapes);
        pos.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return this.bytes.length * 2;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        pos.writeFieldLength(this.bytes.length);
        pos.write(this.bytes);
    }

    @Override
    public void writeLongData(PacketOutputStream pos) throws IOException {
        pos.write(this.bytes);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.VARSTRING;
    }

    @Override
    public String toString() {
        if (this.bytes.length > 1024) {
            return "<bytearray:" + new String(Arrays.copyOfRange(this.bytes, 0, 1024)) + "...>";
        }
        return "<bytearray:" + new String(this.bytes) + ">";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean canBeLongData() {
        return true;
    }
}

