/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.internal.com.send.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.skinsrestorer.shadow.mariadb.internal.ColumnType;
import net.skinsrestorer.shadow.mariadb.internal.com.send.parameters.ParameterHolder;
import net.skinsrestorer.shadow.mariadb.internal.io.output.PacketOutputStream;

public class ReaderParameter
implements Cloneable,
ParameterHolder {
    private final Reader reader;
    private final long length;
    private final boolean noBackslashEscapes;

    public ReaderParameter(Reader reader, long length, boolean noBackslashEscapes) {
        this.reader = reader;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public ReaderParameter(Reader reader, boolean noBackslashEscapes) {
        this(reader, Long.MAX_VALUE, noBackslashEscapes);
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(39);
        if (this.length == Long.MAX_VALUE) {
            pos.write(this.reader, true, this.noBackslashEscapes);
        } else {
            pos.write(this.reader, this.length, true, this.noBackslashEscapes);
        }
        pos.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return -1;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        ByteArrayOutputStream bb = new ByteArrayOutputStream();
        char[] buf = new char[4096];
        if (this.length == Long.MAX_VALUE) {
            int len;
            while ((len = this.reader.read(buf)) >= 0) {
                byte[] data = new String(buf, 0, len).getBytes(StandardCharsets.UTF_8);
                bb.write(data, 0, data.length);
            }
        } else {
            int len;
            for (long maxLen = this.length; (len = this.reader.read(buf)) >= 0 && maxLen > 0L; maxLen -= (long)len) {
                byte[] data = new String(buf, 0, Math.min(len, (int)maxLen)).getBytes(StandardCharsets.UTF_8);
                bb.write(data, 0, data.length);
            }
        }
        byte[] val = bb.toByteArray();
        pos.writeFieldLength(val.length);
        pos.write(val);
    }

    @Override
    public void writeLongData(PacketOutputStream pos) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            pos.write(this.reader, false, this.noBackslashEscapes);
        } else {
            pos.write(this.reader, this.length, false, this.noBackslashEscapes);
        }
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.STRING;
    }

    @Override
    public String toString() {
        return "<Reader>";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean canBeLongData() {
        return true;
    }
}

