/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.internal.failover.impl;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import net.skinsrestorer.shadow.mariadb.HostAddress;
import net.skinsrestorer.shadow.mariadb.UrlParser;
import net.skinsrestorer.shadow.mariadb.internal.failover.AbstractMastersListener;
import net.skinsrestorer.shadow.mariadb.internal.failover.HandleErrorResult;
import net.skinsrestorer.shadow.mariadb.internal.failover.thread.FailoverLoop;
import net.skinsrestorer.shadow.mariadb.internal.failover.tools.SearchFilter;
import net.skinsrestorer.shadow.mariadb.internal.logging.Logger;
import net.skinsrestorer.shadow.mariadb.internal.logging.LoggerFactory;
import net.skinsrestorer.shadow.mariadb.internal.protocol.MasterProtocol;
import net.skinsrestorer.shadow.mariadb.internal.protocol.Protocol;
import net.skinsrestorer.shadow.mariadb.internal.util.constant.HaMode;
import net.skinsrestorer.shadow.mariadb.internal.util.dao.ReconnectDuringTransactionException;
import net.skinsrestorer.shadow.mariadb.internal.util.dao.ServerPrepareResult;
import net.skinsrestorer.shadow.mariadb.internal.util.pool.GlobalStateInfo;

public class MastersFailoverListener
extends AbstractMastersListener {
    private static final Logger logger = LoggerFactory.getLogger(MastersFailoverListener.class);
    private final HaMode mode;

    public MastersFailoverListener(UrlParser urlParser, GlobalStateInfo globalInfo) {
        super(urlParser, globalInfo);
        this.mode = urlParser.getHaMode();
        this.setMasterHostFail();
    }

    @Override
    public void initializeConnection() throws SQLException {
        super.initializeConnection();
        this.currentProtocol = null;
        this.reconnectFailedConnection(new SearchFilter(true, false));
        this.resetMasterFailoverData();
    }

    @Override
    public void preExecute() throws SQLException {
        this.lastQueryNanos = System.nanoTime();
        if (this.currentProtocol != null && this.currentProtocol.isClosed()) {
            this.preAutoReconnect();
        }
    }

    @Override
    public void preClose() {
        if (this.explicitClosed.compareAndSet(false, true)) {
            this.proxy.lock.lock();
            try {
                this.removeListenerFromSchedulers();
                this.closeConnection(this.currentProtocol);
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public long getServerThreadId() {
        return this.currentProtocol.getServerThreadId();
    }

    @Override
    public void preAbort() {
        if (this.explicitClosed.compareAndSet(false, true)) {
            this.proxy.lock.lock();
            try {
                this.removeListenerFromSchedulers();
                this.abortConnection(this.currentProtocol);
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public HandleErrorResult primaryFail(Method method, Object[] args, boolean killCmd, boolean alreadyClosed) {
        boolean inTransaction;
        boolean bl = inTransaction = this.currentProtocol != null && this.currentProtocol.inTransaction();
        if (this.currentProtocol.isConnected()) {
            this.currentProtocol.close();
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, false));
            this.handleFailLoop();
            if (killCmd) {
                return new HandleErrorResult(true, false);
            }
            if (alreadyClosed || !inTransaction && this.isQueryRelaunchable(method, args)) {
                logger.info("Connection to master lost, new master {} found, query type permit to be re-execute on new server without throwing exception", (Object)this.currentProtocol.getHostAddress());
                return this.relaunchOperation(method, args);
            }
            return new HandleErrorResult(true);
        }
        catch (Exception e) {
            if (e.getCause() != null && this.proxy.hasToHandleFailover((SQLException)e.getCause()) && this.currentProtocol.isConnected()) {
                this.currentProtocol.close();
            }
            FailoverLoop.removeListener(this);
            return new HandleErrorResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) throws SQLException {
        this.proxy.lock.lock();
        try {
            if (!(searchFilter.isInitialConnection() || !this.isExplicitClosed() && this.isMasterHostFail())) {
                return;
            }
            this.currentConnectionAttempts.incrementAndGet();
            this.resetOldsBlackListHosts();
            LinkedList<HostAddress> loopAddress = new LinkedList<HostAddress>(this.urlParser.getHostAddresses());
            if (HaMode.LOADBALANCE.equals((Object)this.mode)) {
                loopAddress.removeAll(this.getBlacklistKeys());
                Collections.shuffle(loopAddress);
                LinkedList<HostAddress> blacklistShuffle = new LinkedList<HostAddress>(this.getBlacklistKeys());
                blacklistShuffle.retainAll(this.urlParser.getHostAddresses());
                Collections.shuffle(blacklistShuffle);
                loopAddress.addAll(blacklistShuffle);
            } else {
                loopAddress.removeAll(this.getBlacklistKeys());
                loopAddress.addAll(this.getBlacklistKeys());
                loopAddress.retainAll(this.urlParser.getHostAddresses());
            }
            if (this.currentProtocol != null && !this.isMasterHostFail()) {
                loopAddress.remove(this.currentProtocol.getHostAddress());
            }
            MasterProtocol.loop(this, this.globalInfo, loopAddress, searchFilter);
            if (!this.isMasterHostFail()) {
                FailoverLoop.removeListener(this);
            }
            this.resetMasterFailoverData();
        }
        finally {
            this.proxy.lock.unlock();
        }
    }

    @Override
    public void switchReadOnlyConnection(Boolean mustBeReadOnly) throws SQLException {
        if (this.urlParser.getOptions().assureReadOnly && this.currentReadOnlyAsked != mustBeReadOnly) {
            this.proxy.lock.lock();
            try {
                if (this.currentReadOnlyAsked != mustBeReadOnly) {
                    this.currentReadOnlyAsked = mustBeReadOnly;
                    this.setSessionReadOnly(mustBeReadOnly, this.currentProtocol);
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void foundActiveMaster(Protocol protocol) throws SQLException {
        if (this.isExplicitClosed()) {
            this.proxy.lock.lock();
            try {
                protocol.close();
            }
            finally {
                this.proxy.lock.unlock();
            }
            return;
        }
        this.syncConnection(this.currentProtocol, protocol);
        this.proxy.lock.lock();
        try {
            if (this.currentProtocol != null && !this.currentProtocol.isClosed()) {
                this.currentProtocol.close();
            }
            this.currentProtocol = protocol;
        }
        finally {
            this.proxy.lock.unlock();
        }
        this.resetMasterFailoverData();
        FailoverLoop.removeListener(this);
    }

    @Override
    public void reconnect() throws SQLException {
        boolean inTransaction = this.currentProtocol != null && this.currentProtocol.inTransaction();
        this.reconnectFailedConnection(new SearchFilter(true, false));
        this.handleFailLoop();
        if (inTransaction) {
            throw new ReconnectDuringTransactionException("Connection reconnect automatically during an active transaction", 1401, "25S03");
        }
    }

    @Override
    public void handleFailLoop() {
        if (this.isMasterHostFail()) {
            if (!this.isExplicitClosed()) {
                FailoverLoop.addListener(this);
            }
        } else {
            FailoverLoop.removeListener(this);
        }
    }

    @Override
    public boolean isMasterConnected() {
        return this.currentProtocol != null && this.currentProtocol.isConnected();
    }

    @Override
    public boolean checkMasterStatus(SearchFilter searchFilter) {
        if (this.currentProtocol != null) {
            this.pingMasterProtocol(this.currentProtocol);
        }
        return false;
    }

    @Override
    public void rePrepareOnReplica(ServerPrepareResult oldServerPrepareResult, boolean mustExecuteOnReplica) {
    }

    @Override
    public void reset() throws SQLException {
        if (!this.isMasterHostFail()) {
            this.currentProtocol.reset();
        }
    }
}

