/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.internal.io;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.skinsrestorer.shadow.mariadb.internal.io.TraceObject;
import net.skinsrestorer.shadow.mariadb.internal.util.Utils;

public class LruTraceCache
extends LinkedHashMap<String, TraceObject> {
    private AtomicLong increment = new AtomicLong();

    public LruTraceCache() {
        super(16, 1.0f, false);
    }

    public TraceObject put(TraceObject value) {
        String key = this.increment.incrementAndGet() + "- " + DateTimeFormatter.ISO_INSTANT.format(Instant.now());
        return this.put(key, value);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, TraceObject> eldest) {
        return this.size() > 10;
    }

    public synchronized String printStack() {
        StringBuilder sb = new StringBuilder();
        boolean finished = false;
        while (!finished) {
            try {
                Map.Entry[] arr;
                for (Map.Entry entry : arr = this.entrySet().toArray(new Map.Entry[0])) {
                    TraceObject traceObj = (TraceObject)entry.getValue();
                    if (traceObj.getBuf() == null) continue;
                    String key = (String)entry.getKey();
                    String indicator = "";
                    switch (traceObj.getIndicatorFlag()) {
                        case 2: {
                            indicator = " (compressed protocol - packet not compressed)";
                            break;
                        }
                        case 1: {
                            indicator = " (compressed protocol - packet compressed)";
                            break;
                        }
                    }
                    sb.append("\nthread:").append(traceObj.getThreadId());
                    if (traceObj.isSend()) {
                        sb.append(" send at -exchange:");
                    } else {
                        sb.append(" read at -exchange:");
                    }
                    sb.append(key).append(indicator).append(Utils.hexdump(traceObj.getBuf()));
                }
                finished = true;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        this.clear();
        return sb.toString();
    }

    public synchronized void clearMemory() {
        try {
            Collection traceObjects = this.values();
            for (TraceObject traceObject : traceObjects) {
                traceObject.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        this.clear();
    }
}

