/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.internal.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.skinsrestorer.shadow.mariadb.internal.com.read.Buffer;
import net.skinsrestorer.shadow.mariadb.internal.io.LruTraceCache;
import net.skinsrestorer.shadow.mariadb.internal.io.TraceObject;
import net.skinsrestorer.shadow.mariadb.internal.io.input.PacketInputStream;
import net.skinsrestorer.shadow.mariadb.internal.logging.Logger;
import net.skinsrestorer.shadow.mariadb.internal.logging.LoggerFactory;
import net.skinsrestorer.shadow.mariadb.internal.util.Utils;

public class DecompressPacketInputStream
implements PacketInputStream {
    private static final int REUSABLE_BUFFER_LENGTH = 1024;
    private static final int MAX_PACKET_SIZE = 0xFFFFFF;
    private static final Logger logger = LoggerFactory.getLogger(DecompressPacketInputStream.class);
    private final byte[] header = new byte[7];
    private final byte[] reusableArray = new byte[1024];
    private final InputStream inputStream;
    private final int maxQuerySizeToLog;
    private byte[] cacheData = new byte[0];
    private int cachePos;
    private int cacheEnd;
    private int packetSeq;
    private int compressPacketSeq;
    private String serverThreadLog = "";
    private LruTraceCache traceCache = null;
    private long threadId;

    public DecompressPacketInputStream(InputStream in, int maxQuerySizeToLog, long threadId) {
        this.inputStream = in;
        this.maxQuerySizeToLog = maxQuerySizeToLog;
        this.threadId = threadId;
    }

    @Override
    public Buffer getPacket(boolean reUsable) throws IOException {
        return new Buffer(this.getPacketArray(reUsable));
    }

    @Override
    public byte[] getPacketArray(boolean reUsable) throws IOException {
        byte[] packet;
        byte[] cachePacket = this.getNextCachePacket();
        if (cachePacket != null) {
            return cachePacket;
        }
        do {
            int length;
            this.readBlocking(this.header, 7);
            int compressedLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
            this.compressPacketSeq = this.header[3] & 0xFF;
            int decompressedLength = (this.header[4] & 0xFF) + ((this.header[5] & 0xFF) << 8) + ((this.header[6] & 0xFF) << 16);
            byte[] rawBytes = reUsable && decompressedLength == 0 && compressedLength < 1024 ? this.reusableArray : new byte[decompressedLength != 0 ? decompressedLength : compressedLength];
            this.readCompressBlocking(rawBytes, compressedLength, decompressedLength);
            if (this.traceCache != null) {
                length = decompressedLength != 0 ? decompressedLength : compressedLength;
                this.traceCache.put(new TraceObject(false, decompressedLength == 0 ? 2 : 1, this.threadId, Arrays.copyOfRange(this.header, 0, 7), Arrays.copyOfRange(rawBytes, 0, length > 1000 ? 1000 : length)));
            }
            if (logger.isTraceEnabled()) {
                length = decompressedLength != 0 ? decompressedLength : compressedLength;
                logger.trace("read {} {}{}", decompressedLength == 0 ? "uncompress" : "compress", this.serverThreadLog, Utils.hexdump(this.maxQuerySizeToLog - 7, 0, length, (byte[][])new byte[][]{this.header, rawBytes}));
            }
            this.cache(rawBytes, decompressedLength == 0 ? compressedLength : decompressedLength);
        } while ((packet = this.getNextCachePacket()) == null);
        return packet;
    }

    private void readCompressBlocking(byte[] arr, int compressedLength, int decompressedLength) throws IOException {
        if (decompressedLength != 0) {
            byte[] compressedBuffer = new byte[compressedLength];
            this.readBlocking(compressedBuffer, compressedLength);
            Inflater inflater = new Inflater();
            inflater.setInput(compressedBuffer);
            try {
                int actualUncompressBytes = inflater.inflate(arr);
                if (actualUncompressBytes != decompressedLength) {
                    throw new IOException("Invalid exception length after decompression " + actualUncompressBytes + ",expected " + decompressedLength);
                }
            }
            catch (DataFormatException dfe) {
                throw new IOException(dfe);
            }
            inflater.end();
        } else {
            this.readBlocking(arr, compressedLength);
        }
    }

    private void readBlocking(byte[] arr, int length) throws IOException {
        int count;
        int remaining = length;
        int off = 0;
        do {
            if ((count = this.inputStream.read(arr, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (length - remaining) + " bytes from " + length + " (socket was closed by server)");
            }
            off += count;
        } while ((remaining -= count) > 0);
    }

    private void cache(byte[] rawBytes, int length) {
        if (this.cachePos >= this.cacheEnd) {
            this.cacheData = rawBytes;
            this.cachePos = 0;
            this.cacheEnd = length;
        } else {
            byte[] newCache = new byte[length + this.cacheEnd - this.cachePos];
            System.arraycopy(this.cacheData, this.cachePos, newCache, 0, this.cacheEnd - this.cachePos);
            System.arraycopy(rawBytes, 0, newCache, this.cacheEnd - this.cachePos, length);
            this.cacheData = newCache;
            this.cachePos = 0;
            this.cacheEnd = newCache.length;
        }
    }

    private byte[] getNextCachePacket() {
        int packetOffset = 0;
        while (this.cacheEnd > this.cachePos + 4 + packetOffset * 0x1000003) {
            int lastPacketLength = (this.cacheData[this.cachePos + packetOffset * 0x1000003] & 0xFF) + ((this.cacheData[this.cachePos + packetOffset * 0x1000003 + 1] & 0xFF) << 8) + ((this.cacheData[this.cachePos + packetOffset * 0x1000003 + 2] & 0xFF) << 16);
            if (lastPacketLength == 0xFFFFFF) {
                ++packetOffset;
                continue;
            }
            if (this.cacheEnd >= this.cachePos + 4 + packetOffset * 0x1000003 + lastPacketLength) {
                if (packetOffset == 0) {
                    this.packetSeq = this.cacheData[this.cachePos + 3];
                    if (this.cacheEnd - (this.cachePos + 4) < lastPacketLength) continue;
                    byte[] packet = new byte[lastPacketLength];
                    System.arraycopy(this.cacheData, this.cachePos + 4, packet, 0, lastPacketLength);
                    if (logger.isTraceEnabled()) {
                        logger.trace("read packet: seq={} len={} {}{}", this.packetSeq, lastPacketLength, this.serverThreadLog, Utils.hexdump(this.maxQuerySizeToLog, this.cachePos + 4, lastPacketLength, (byte[][])new byte[][]{this.cacheData}));
                    }
                    this.cachePos += 4 + lastPacketLength;
                    return packet;
                }
                byte[] packet = new byte[lastPacketLength + packetOffset * 0xFFFFFF];
                int offset = 0;
                do {
                    lastPacketLength = (this.cacheData[this.cachePos] & 0xFF) + ((this.cacheData[this.cachePos + 1] & 0xFF) << 8) + ((this.cacheData[this.cachePos + 2] & 0xFF) << 16);
                    this.packetSeq = this.cacheData[this.cachePos + 3];
                    System.arraycopy(this.cacheData, this.cachePos + 4, packet, offset, lastPacketLength);
                    offset += lastPacketLength;
                    if (logger.isTraceEnabled()) {
                        logger.trace("read packet: seq={} len={} {}{}", this.packetSeq, lastPacketLength, this.serverThreadLog, Utils.hexdump(this.maxQuerySizeToLog, this.cachePos + 4, lastPacketLength, (byte[][])new byte[][]{this.cacheData}));
                    }
                    this.cachePos += 4 + lastPacketLength;
                } while (lastPacketLength == 0xFFFFFF);
                return packet;
            }
            return null;
        }
        return null;
    }

    @Override
    public int getLastPacketSeq() {
        return this.packetSeq;
    }

    @Override
    public int getCompressLastPacketSeq() {
        return this.compressPacketSeq;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void setServerThreadId(long serverThreadId, Boolean isMaster) {
        this.serverThreadLog = "conn=" + serverThreadId + (isMaster != null ? "(" + (isMaster != false ? "M" : "S") + ")" : "");
    }

    @Override
    public void setTraceCache(LruTraceCache traceCache) {
        this.traceCache = traceCache;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }
}

