/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.internal.io.socket;

import com.sun.jna.Platform;
import java.io.IOException;
import net.skinsrestorer.shadow.mariadb.internal.io.socket.NamedPipeSocket;
import net.skinsrestorer.shadow.mariadb.internal.io.socket.SharedMemorySocket;
import net.skinsrestorer.shadow.mariadb.internal.io.socket.SocketHandlerFunction;
import net.skinsrestorer.shadow.mariadb.internal.io.socket.UnixDomainSocket;
import net.skinsrestorer.shadow.mariadb.internal.util.Utils;

public class SocketUtility {
    public static SocketHandlerFunction getSocketHandler() {
        try {
            Platform.getOSType();
            return (options, host) -> {
                if (options.pipe != null) {
                    return new NamedPipeSocket(host, options.pipe);
                }
                if (options.localSocket != null) {
                    try {
                        return new UnixDomainSocket(options.localSocket);
                    }
                    catch (RuntimeException re) {
                        throw new IOException(re.getMessage(), re.getCause());
                    }
                }
                if (options.sharedMemory != null) {
                    try {
                        return new SharedMemorySocket(options.sharedMemory);
                    }
                    catch (RuntimeException re) {
                        throw new IOException(re.getMessage(), re.getCause());
                    }
                }
                return Utils.standardSocket(options, host);
            };
        }
        catch (Throwable throwable) {
            return (options, host) -> Utils.standardSocket(options, host);
        }
    }
}

