/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.internal.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import net.skinsrestorer.shadow.mariadb.internal.com.send.parameters.ParameterHolder;
import net.skinsrestorer.shadow.mariadb.internal.logging.Logger;
import net.skinsrestorer.shadow.mariadb.internal.logging.LoggerFactory;
import net.skinsrestorer.shadow.mariadb.internal.protocol.Protocol;
import net.skinsrestorer.shadow.mariadb.internal.util.dao.ClientPrepareResult;
import net.skinsrestorer.shadow.mariadb.internal.util.dao.PrepareResult;
import net.skinsrestorer.shadow.mariadb.internal.util.dao.ServerPrepareResult;
import net.skinsrestorer.shadow.mariadb.util.Options;

public class ProtocolLoggingProxy
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolLoggingProxy.class);
    private final NumberFormat numberFormat;
    private final boolean profileSql;
    private final Long slowQueryThresholdNanos;
    private final int maxQuerySizeToLog;
    private final Protocol protocol;

    public ProtocolLoggingProxy(Protocol protocol, Options options) {
        this.protocol = protocol;
        this.profileSql = options.profileSql;
        this.slowQueryThresholdNanos = options.slowQueryThresholdNanos;
        this.maxQuerySizeToLog = options.maxQuerySizeToLog;
        this.numberFormat = DecimalFormat.getInstance();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            switch (method.getName()) {
                case "executeQuery": 
                case "executePreparedQuery": 
                case "executeBatchStmt": 
                case "executeBatchClient": 
                case "executeBatchServer": {
                    long startTime = System.nanoTime();
                    Object returnObj = method.invoke((Object)this.protocol, args);
                    if (logger.isInfoEnabled() && (this.profileSql || this.slowQueryThresholdNanos != null && System.nanoTime() - startTime > this.slowQueryThresholdNanos)) {
                        String sql = this.logQuery(method.getName(), args);
                        logger.info("conn={}({}) - {} ms - Query: {}", this.protocol.getServerThreadId(), this.protocol.isMasterConnection() ? "M" : "S", this.numberFormat.format(((double)System.nanoTime() - (double)startTime) / 1000000.0), this.subQuery(sql));
                    }
                    return returnObj;
                }
            }
            return method.invoke((Object)this.protocol, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private String logQuery(String methodName, Object[] args) {
        switch (methodName) {
            case "executeQuery": {
                switch (args.length) {
                    case 1: {
                        return (String)args[0];
                    }
                    case 3: {
                        return (String)args[2];
                    }
                    case 4: 
                    case 5: {
                        if (args[3] instanceof Charset) {
                            return (String)args[2];
                        }
                        ClientPrepareResult clientPrepareResult = (ClientPrepareResult)args[2];
                        return this.getQueryFromPrepareParameters(clientPrepareResult, (ParameterHolder[])args[3], clientPrepareResult.getParamCount());
                    }
                }
                break;
            }
            case "executeBatchClient": {
                ClientPrepareResult clientPrepareResult = (ClientPrepareResult)args[2];
                return this.getQueryFromPrepareParameters(clientPrepareResult.getSql(), (List)args[3], clientPrepareResult.getParamCount());
            }
            case "executeBatchStmt": {
                List multipleQueries = (List)args[2];
                if (multipleQueries.size() == 1) {
                    return (String)multipleQueries.get(0);
                }
                StringBuilder sb = new StringBuilder();
                for (String multipleQuery : multipleQueries) {
                    if (this.maxQuerySizeToLog > 0 && sb.length() + multipleQuery.length() + 1 > this.maxQuerySizeToLog) {
                        sb.append(multipleQuery, 1, Math.max(1, this.maxQuerySizeToLog - sb.length()));
                        break;
                    }
                    sb.append(multipleQuery).append(";");
                    if (this.maxQuerySizeToLog <= 0 || sb.length() < this.maxQuerySizeToLog) continue;
                    break;
                }
                return sb.toString();
            }
            case "executeBatchServer": {
                List parameterList = (List)args[4];
                ServerPrepareResult serverPrepareResult = (ServerPrepareResult)args[1];
                return this.getQueryFromPrepareParameters(serverPrepareResult.getSql(), parameterList, serverPrepareResult.getParamCount());
            }
            case "executePreparedQuery": {
                ServerPrepareResult prepareResult = (ServerPrepareResult)args[1];
                if (args[3] instanceof ParameterHolder[]) {
                    return this.getQueryFromPrepareParameters(prepareResult, (ParameterHolder[])args[3], prepareResult.getParamCount());
                }
                return this.getQueryFromPrepareParameters(prepareResult.getSql(), (List)args[3], prepareResult.getParameters().length);
            }
        }
        return "-unknown-";
    }

    public String subQuery(String sql) {
        if (this.maxQuerySizeToLog > 0 && sql.length() > this.maxQuerySizeToLog - 3) {
            return sql.substring(0, this.maxQuerySizeToLog - 3) + "...";
        }
        return sql;
    }

    private String getQueryFromPrepareParameters(String sql, List<ParameterHolder[]> parameterList, int parameterLength) {
        if (parameterLength == 0) {
            return sql;
        }
        StringBuilder sb = new StringBuilder(sql).append(", parameters ");
        for (int paramNo = 0; paramNo < parameterList.size(); ++paramNo) {
            ParameterHolder[] parameters = parameterList.get(paramNo);
            if (paramNo != 0) {
                sb.append(",");
            }
            sb.append("[");
            for (int i = 0; i < parameterLength; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(parameters[i].toString());
            }
            if (this.maxQuerySizeToLog > 0 && sb.length() > this.maxQuerySizeToLog) break;
            sb.append("]");
        }
        return sb.toString();
    }

    private String getQueryFromPrepareParameters(PrepareResult serverPrepareResult, ParameterHolder[] paramHolders, int parameterLength) {
        StringBuilder sb = new StringBuilder(serverPrepareResult.getSql());
        if (paramHolders.length > 0) {
            sb.append(", parameters [");
            for (int i = 0; i < parameterLength; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(paramHolders[i].toString());
                if (this.maxQuerySizeToLog > 0 && sb.length() > this.maxQuerySizeToLog) break;
            }
            return sb.append("]").toString();
        }
        return serverPrepareResult.getSql();
    }
}

