/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.interfaces;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shared.storage.SkinStorage;
import net.skinsrestorer.shared.utils.CommandPropertiesManager;
import net.skinsrestorer.shared.utils.CommandReplacements;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.SharedMethods;
import net.skinsrestorer.shared.utils.log.SRLogger;

public interface ISRPlugin {
    public File getDataFolder();

    public SkinStorage getSkinStorage();

    public String getVersion();

    public MetricsCounter getMetricsCounter();

    public InputStream getResource(String var1);

    default public void prepareACF(CommandManager<?, ?, ?, ?, ?, ?> manager, SRLogger srLogger) {
        manager.enableUnstableAPI("help");
        CommandReplacements.permissions.forEach((k, v) -> manager.getCommandReplacements().addReplacement((String)k, (String)v.call()));
        CommandReplacements.descriptions.forEach((k, v) -> manager.getCommandReplacements().addReplacement((String)k, (String)v.call()));
        CommandReplacements.syntax.forEach((k, v) -> manager.getCommandReplacements().addReplacement((String)k, (String)v.call()));
        CommandReplacements.completions.forEach((k, v) -> manager.getCommandCompletions().registerAsyncCompletion((String)k, c -> Arrays.asList(((String)v.call()).split(", "))));
        CommandPropertiesManager.load(manager, this.getDataFolder(), this.getResource("command-messages.properties"), srLogger);
        SharedMethods.allowIllegalACFNames();
    }
}

