/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CooldownStorage
implements Runnable {
    private static final Map<String, Long> cooldown = new ConcurrentHashMap<String, Long>();

    public static boolean hasCooldown(String name) {
        Long expire = cooldown.get(name);
        return expire != null && expire > System.currentTimeMillis();
    }

    public static void resetCooldown(String name) {
        cooldown.remove(name);
    }

    public static int getCooldown(String name) {
        int int1 = Integer.parseInt(String.format("%d", TimeUnit.MILLISECONDS.toSeconds(cooldown.get(name))));
        int int2 = Integer.parseInt(String.format("%d", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())));
        return int1 - int2;
    }

    public static void setCooldown(String name, int cooldownTime, TimeUnit timeunit) {
        cooldown.put(name, System.currentTimeMillis() + timeunit.toMillis(cooldownTime));
    }

    @Override
    public void run() {
        long current = System.currentTimeMillis();
        cooldown.values().removeIf(aLong -> aLong <= current);
    }
}

