/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetProvider;
import net.skinsrestorer.shadow.ijannotations.Language;
import net.skinsrestorer.shadow.mariadb.Driver;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class MySQL {
    private final SRLogger logger;
    private final String host;
    private final String port;
    private final String database;
    private final String username;
    private final String password;
    private final String options;
    private final ExecutorService exe = Executors.newCachedThreadPool();
    private Connection con;

    public void createTable() {
        this.execute("CREATE TABLE IF NOT EXISTS `" + Config.MYSQL_PLAYER_TABLE + "` (`Nick` varchar(16) COLLATE utf8_unicode_ci NOT NULL,`Skin` varchar(16) COLLATE utf8_unicode_ci NOT NULL,PRIMARY KEY (`Nick`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci", new Object[0]);
        this.execute("CREATE TABLE IF NOT EXISTS `" + Config.MYSQL_SKIN_TABLE + "` (`Nick` varchar(16) COLLATE utf8_unicode_ci NOT NULL,`Value` text COLLATE utf8_unicode_ci,`Signature` text COLLATE utf8_unicode_ci,`timestamp` text COLLATE utf8_unicode_ci,PRIMARY KEY (`Nick`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci", new Object[0]);
        this.execute("ALTER TABLE `" + Config.MYSQL_SKIN_TABLE + "` ADD `timestamp` text COLLATE utf8_unicode_ci;", new Object[0]);
    }

    public Connection openConnection() throws SQLException {
        new Driver();
        this.con = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?" + this.options, this.username, this.password);
        this.logger.info("Connected to MySQL!");
        return this.con;
    }

    private Connection getConnection() {
        try {
            if (this.con == null || !this.con.isValid(1)) {
                this.logger.info("MySQL connection lost! Creation a new one.");
                this.con = this.openConnection();
            }
        }
        catch (SQLException e) {
            this.logger.info("Could NOT connect to MySQL: " + e.getMessage());
        }
        try (PreparedStatement stmt = this.con.prepareStatement("SELECT 1");){
            stmt.execute();
        }
        catch (SQLException e) {
            this.logger.info("MySQL SELECT 1 failed. Reconnecting");
            try {
                this.con = this.openConnection();
                return this.con;
            }
            catch (SQLException e1) {
                this.logger.warning("Couldn't reconnect to MySQL!");
                e1.printStackTrace();
            }
        }
        return this.con;
    }

    private PreparedStatement prepareStatement(Connection conn, @Language(value="sql") String query, Object ... vars) {
        try {
            PreparedStatement ps = conn.prepareStatement(query);
            int i = 0;
            for (Object obj : vars) {
                ps.setObject(++i, obj);
            }
            return ps;
        }
        catch (SQLException e) {
            this.logger.warning("MySQL error: " + e.getMessage());
            return null;
        }
    }

    public void execute(@Language(value="sql") String query, Object ... vars) {
        Connection conn = this.getConnection();
        try (PreparedStatement ps = this.prepareStatement(conn, query, vars);){
            assert (ps != null);
            ps.execute();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1060) {
                return;
            }
            e.printStackTrace();
            this.logger.warning("MySQL error: " + e.getMessage());
        }
    }

    public CachedRowSet query(@Language(value="sql") String query, Object ... vars) {
        Connection conn = this.getConnection();
        CachedRowSet rowSet = null;
        try {
            Future<CachedRowSet> future = this.exe.submit(() -> {
                try (PreparedStatement ps = this.prepareStatement(conn, query, vars);){
                    assert (ps != null);
                    try (ResultSet rs = ps.executeQuery();){
                        CachedRowSet crs = RowSetProvider.newFactory().createCachedRowSet();
                        crs.populate(rs);
                        if (!crs.next()) return null;
                        CachedRowSet cachedRowSet = crs;
                        return cachedRowSet;
                    }
                }
                catch (SQLException e) {
                    this.logger.warning("MySQL error: " + e.getMessage());
                }
                return null;
            });
            if (future.get() != null) {
                rowSet = future.get();
            }
        }
        catch (Exception e) {
            this.logger.warning("MySQL error: " + e.getMessage());
        }
        return rowSet;
    }

    public MySQL(SRLogger logger, String host, String port, String database, String username, String password, String options) {
        this.logger = logger;
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.options = options;
    }
}

