/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.skinsrestorer.shadow.configurate.ConfigurateException;
import net.skinsrestorer.shadow.configurate.ConfigurationNode;
import net.skinsrestorer.shadow.configurate.yaml.YamlConfigurationLoader;
import net.skinsrestorer.shared.exception.YamlException;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class YamlConfig {
    private final String name;
    private final boolean setMissing;
    private final File file;
    private final SRLogger logger;
    private ConfigurationNode config;

    public YamlConfig(File path, String name, boolean setMissing, SRLogger logger) {
        this.name = name;
        this.setMissing = setMissing;
        this.file = new File(path, name);
        this.logger = logger;
        if (!path.exists()) {
            path.mkdirs();
        }
    }

    public void saveDefaultConfig(InputStream is) {
        if (this.file.exists()) {
            return;
        }
        if (is == null) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            Files.copy(is, this.file.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.reload();
        }
        catch (YamlException e) {
            e.printStackTrace();
        }
    }

    public ConfigurationNode get(String path) {
        try {
            return this.config.node(path.split("\\."));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ConfigurationNode get(String path, String defValue) {
        if (this.get(path).virtual() && this.setMissing) {
            this.logger.info("Saving new config value " + path + " to " + this.name);
            this.set(path, defValue);
        }
        return this.get(path);
    }

    public boolean getBoolean(String path) {
        return this.get(path).getBoolean();
    }

    public boolean getBoolean(String path, Boolean defValue) {
        return this.get(path).getBoolean(defValue);
    }

    public int getInt(String path) {
        return this.get(path).getInt();
    }

    public int getInt(String path, Integer defValue) {
        return this.get(path).getInt(defValue);
    }

    private String getString(String path) {
        return this.get(path).getString();
    }

    public String getString(String path, String defValue) {
        return this.get(path, defValue).getString(defValue);
    }

    public List<String> getStringList(String path) {
        try {
            return this.get(path).getList(String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public List<String> getStringList(String path, String whatToDelete) {
        try {
            List<String> list = this.getStringList(path);
            ArrayList<String> newList = new ArrayList<String>();
            for (String str : list) {
                newList.add(str.replace(whatToDelete, ""));
            }
            return newList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public void reload() throws YamlException {
        try {
            this.config = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(this.file.toPath())).build().load();
        }
        catch (ConfigurateException ex) {
            throw new YamlException(ex);
        }
    }

    private void save() throws YamlException {
        try {
            ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(this.file.toPath())).build().save(this.config);
        }
        catch (ConfigurateException ex) {
            throw new YamlException(ex);
        }
    }

    public void set(String path, Object value) {
        try {
            ConfigurationNode node = this.config.node(path.split("\\."));
            if (value instanceof List) {
                node.setList(String.class, (List)value);
            } else {
                node.set(value);
            }
            this.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

