/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.update;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.skinsrestorer.shadow.gson.Gson;
import net.skinsrestorer.shadow.spiget.ResourceInfo;
import net.skinsrestorer.shadow.spiget.ResourceVersion;
import net.skinsrestorer.shadow.spiget.UpdateCallback;
import net.skinsrestorer.shadow.spiget.comparator.VersionComparator;
import net.skinsrestorer.shared.utils.log.SRLogLevel;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class UpdateChecker {
    public static final String RESOURCE_INFO = "https://api.spiget.org/v2/resources/%s?ut=%s";
    public static final String RESOURCE_VERSION = "https://api.spiget.org/v2/resources/%s/versions/latest?ut=%s";
    private final int resourceId;
    private final SRLogger log;
    private final String currentVersion;
    private final String userAgent;
    private ResourceInfo latestResourceInfo;

    public UpdateChecker(int resourceId, String currentVersion, SRLogger log, String userAgent) {
        this.resourceId = resourceId;
        this.currentVersion = currentVersion;
        this.log = log;
        this.userAgent = userAgent;
    }

    public void checkForUpdate(UpdateCallback callback) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(String.format(RESOURCE_INFO, this.resourceId, System.currentTimeMillis())).openConnection();
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            this.latestResourceInfo = new Gson().fromJson((Reader)new InputStreamReader(connection.getInputStream()), ResourceInfo.class);
            connection = (HttpURLConnection)new URL(String.format(RESOURCE_VERSION, this.resourceId, System.currentTimeMillis())).openConnection();
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            this.latestResourceInfo.latestVersion = new Gson().fromJson((Reader)new InputStreamReader(connection.getInputStream()), ResourceVersion.class);
            if (this.isVersionNewer(this.currentVersion, this.latestResourceInfo.latestVersion.name)) {
                callback.updateAvailable(this.latestResourceInfo.latestVersion.name, "https://spigotmc.org/" + this.latestResourceInfo.file.url, !this.latestResourceInfo.external);
            } else {
                callback.upToDate();
            }
        }
        catch (Exception e) {
            this.log.debug(SRLogLevel.WARNING, "Failed to get resource info from spiget.org", e);
        }
    }

    public List<String> getUpToDateMessages(String currentVersion, boolean bungeeMode) {
        LinkedList<String> upToDateMessages = new LinkedList<String>();
        upToDateMessages.add("\u00a7a----------------------------------------------");
        upToDateMessages.add("\u00a7a    +==================+");
        upToDateMessages.add("\u00a7a    |   SkinsRestorer  |");
        upToDateMessages.add("\u00a7a    |------------------|");
        if (bungeeMode) {
            upToDateMessages.add("\u00a7a    |   \u00a7eBungee Mode\u00a7a    |");
        } else {
            try {
                Class.forName("org.bukkit.Bukkit");
                upToDateMessages.add("\u00a7a    |  \u00a79\u00a7n\u00a7lStandalone Mode\u00a7a |");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        upToDateMessages.add("\u00a7a    +==================+");
        upToDateMessages.add("\u00a7a----------------------------------------------");
        upToDateMessages.add("\u00a7b    Current version: \u00a7a" + currentVersion);
        upToDateMessages.add("\u00a7a    This is the latest version!");
        upToDateMessages.add("\u00a7a----------------------------------------------");
        return upToDateMessages;
    }

    public List<String> getUpdateAvailableMessages(String newVersion, String downloadUrl, boolean hasDirectDownload, String currentVersion, boolean bungeeMode) {
        return this.getUpdateAvailableMessages(newVersion, downloadUrl, hasDirectDownload, currentVersion, bungeeMode, false, null);
    }

    public List<String> getUpdateAvailableMessages(String newVersion, String downloadUrl, boolean hasDirectDownload, String currentVersion, boolean bungeeMode, boolean updateDownloader, String failReason) {
        LinkedList<String> updateAvailableMessages = new LinkedList<String>();
        updateAvailableMessages.add("\u00a7a----------------------------------------------");
        updateAvailableMessages.add("\u00a7a    +==================+");
        updateAvailableMessages.add("\u00a7a    |   SkinsRestorer  |");
        updateAvailableMessages.add("\u00a7a    |------------------|");
        if (bungeeMode) {
            updateAvailableMessages.add("\u00a7a    |   \u00a7eBungee Mode\u00a7a    |");
        } else {
            try {
                Class.forName("org.bukkit.Bukkit");
                updateAvailableMessages.add("\u00a7a    |  \u00a79\u00a7n\u00a7lStandalone Mode\u00a7a |");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        updateAvailableMessages.add("\u00a7a    +==================+");
        updateAvailableMessages.add("\u00a7a----------------------------------------------");
        updateAvailableMessages.add("\u00a7b    Current version: \u00a7c" + currentVersion);
        updateAvailableMessages.add("\u00a7b    New version: \u00a7c" + newVersion);
        if (updateDownloader && hasDirectDownload) {
            updateAvailableMessages.add("    A new version is available! Downloading it now...");
            if (failReason == null) {
                updateAvailableMessages.add("    Update downloaded successfully, it will be applied on the next restart.");
            } else {
                updateAvailableMessages.add("\u00a7cCould not download the update, reason: " + failReason);
            }
        } else {
            updateAvailableMessages.add("\u00a7e    A new version is available! Download it at:");
            updateAvailableMessages.add("\u00a7e    " + downloadUrl);
        }
        updateAvailableMessages.add("\u00a7a----------------------------------------------");
        return updateAvailableMessages;
    }

    public boolean isVersionNewer(String oldVersion, String newVersion) {
        return VersionComparator.SEM_VER_SNAPSHOT.isNewer(oldVersion, newVersion);
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public ResourceInfo getLatestResourceInfo() {
        return this.latestResourceInfo;
    }
}

