/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.update;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.skinsrestorer.shadow.gson.Gson;
import net.skinsrestorer.shadow.spiget.UpdateCallback;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.update.GitHubReleaseInfo;
import net.skinsrestorer.shared.update.UpdateChecker;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class UpdateCheckerGitHub
extends UpdateChecker {
    private static final String RESOURCE_ID = "SkinsRestorerX";
    private static final String RELEASES_URL_LATEST = "https://api.github.com/repos/SkinsRestorer/%s/releases/latest";
    private final SRLogger log;
    private final String userAgent;
    private final String currentVersion;
    private GitHubReleaseInfo releaseInfo;

    public UpdateCheckerGitHub(int resourceId, String currentVersion, SRLogger log, String userAgent) {
        super(resourceId, currentVersion, log, userAgent);
        this.log = log;
        this.userAgent = userAgent;
        this.currentVersion = currentVersion;
    }

    @Override
    public void checkForUpdate(UpdateCallback callback) {
        block2: {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(String.format(RELEASES_URL_LATEST, RESOURCE_ID)).openConnection();
                connection.setRequestProperty("User-Agent", this.userAgent);
                this.releaseInfo = new Gson().fromJson((Reader)new InputStreamReader(connection.getInputStream()), GitHubReleaseInfo.class);
                this.releaseInfo.assets.forEach(gitHubAssetInfo -> {
                    this.releaseInfo.latestDownloadURL = gitHubAssetInfo.browser_download_url;
                    if (this.isVersionNewer(this.currentVersion, this.releaseInfo.tag_name)) {
                        callback.updateAvailable(this.releaseInfo.tag_name, gitHubAssetInfo.browser_download_url, true);
                    } else {
                        callback.upToDate();
                    }
                });
            }
            catch (Exception e) {
                this.log.warning("Failed to get release info from api.github.com. \n If this message is repeated a lot, please see http://skinsrestorer.net/firewall");
                if (!Config.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public GitHubReleaseInfo getLatestResourceInfo() {
        return this.releaseInfo;
    }
}

