/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils.connections;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.shared.utils.connections.MojangAPI;

public class ServiceChecker {
    private static final String XKNAT_NAME = "xknat";
    private static final String XKNAT_UUID = "7dcfc130344a47199fbe3176bc2075c6";
    private final ServiceCheckResponse response = new ServiceCheckResponse();
    private MojangAPI mojangAPI;

    public void checkServices() {
        Optional<String> uuid;
        try {
            uuid = this.mojangAPI.getUUIDAshcon(XKNAT_NAME);
            if (uuid.isPresent() && !uuid.get().equalsIgnoreCase("null")) {
                this.response.addResult("Ashcon UUID \u00a7a\u2714 xknat UUID: \u00a7b" + uuid);
                this.response.incrementWorkingUUID();
            } else {
                this.response.addResult("Ashcon UUID \u00a7c\u2718 Error getting UUID: null");
            }
        }
        catch (SkinRequestException e) {
            this.response.addResult("Ashcon UUID \u00a7c\u2718 Error getting UUID: " + e.getMessage());
        }
        try {
            uuid = this.mojangAPI.getUUIDMojang(XKNAT_NAME);
            if (uuid.isPresent() && !uuid.get().equalsIgnoreCase("null")) {
                this.response.addResult("Mojang API UUID \u00a7a\u2714 xknat UUID: \u00a7b" + uuid);
                this.response.incrementWorkingUUID();
            } else {
                this.response.addResult("Mojang API UUID \u00a7c\u2718 Error getting UUID: null");
            }
        }
        catch (SkinRequestException e) {
            this.response.addResult("Mojang API UUID \u00a7c\u2718 Error getting UUID: " + e.getMessage());
        }
        try {
            uuid = this.mojangAPI.getUUIDMinetools(XKNAT_NAME);
            if (uuid.isPresent() && !uuid.get().equalsIgnoreCase("null")) {
                this.response.addResult("Minetools API UUID \u00a7a\u2714 xknat UUID: \u00a7b" + uuid);
                this.response.incrementWorkingUUID();
            } else {
                this.response.addResult("Minetools API UUID \u00a7c\u2718 Error getting UUID: null");
            }
        }
        catch (SkinRequestException e) {
            this.response.addResult("Minetools API UUID \u00a7c\u2718 Error getting UUID: " + e.getMessage());
        }
        Optional<IProperty> ashcon = this.mojangAPI.getProfileAshcon(XKNAT_UUID);
        if (ashcon.isPresent()) {
            this.response.addResult("Ashcon Profile \u00a7a\u2714 xknat Profile: \u00a7b" + ashcon);
            this.response.incrementWorkingProfile();
        } else {
            this.response.addResult("Ashcon Profile \u00a7c\u2718 Error getting Profile: null");
        }
        Optional<IProperty> mojang = this.mojangAPI.getProfileMojang(XKNAT_UUID);
        if (mojang.isPresent()) {
            this.response.addResult("Mojang-API Profile \u00a7a\u2714 xknat Profile: \u00a7b" + mojang);
            this.response.incrementWorkingProfile();
        } else {
            this.response.addResult("Mojang-API Profile \u00a7c\u2718 Error getting Profile: null");
        }
        Optional<IProperty> minetools = this.mojangAPI.getProfileMinetools(XKNAT_UUID);
        if (minetools.isPresent()) {
            this.response.addResult("Minetools Profile \u00a7a\u2714 xknat Profile: \u00a7b" + minetools);
            this.response.incrementWorkingProfile();
        } else {
            this.response.addResult("Minetools Profile \u00a7c\u2718 Error getting Profile: null");
        }
    }

    public ServiceCheckResponse getResponse() {
        return this.response;
    }

    public void setMojangAPI(MojangAPI mojangAPI) {
        this.mojangAPI = mojangAPI;
    }

    public static class ServiceCheckResponse {
        private final List<String> results = new LinkedList<String>();
        private final AtomicInteger workingUUID = new AtomicInteger();
        private final AtomicInteger workingProfile = new AtomicInteger();

        public void addResult(String result) {
            this.results.add(result);
        }

        public void incrementWorkingUUID() {
            this.workingUUID.getAndIncrement();
        }

        public void incrementWorkingProfile() {
            this.workingProfile.getAndIncrement();
        }

        public List<String> getResults() {
            return this.results;
        }

        public AtomicInteger getWorkingUUID() {
            return this.workingUUID;
        }

        public AtomicInteger getWorkingProfile() {
            return this.workingProfile;
        }
    }
}

