/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.skinsrestorer.api.interfaces.ISRConsole;
import net.skinsrestorer.shared.interfaces.ISRLogger;
import net.skinsrestorer.shared.utils.log.SRLogLevel;

public class LoggerImpl
implements ISRLogger {
    private final Logger logger;
    private final ISRConsole console;

    @Override
    public void log(SRLogLevel level, String message) {
        switch (level) {
            case INFO: {
                this.console.sendMessage(message);
                break;
            }
            case WARNING: {
                this.logger.log(Level.WARNING, message);
                break;
            }
            case SEVERE: {
                this.logger.severe(message);
                break;
            }
        }
    }

    @Override
    public void log(SRLogLevel level, String message, Throwable throwable) {
        switch (level) {
            case INFO: {
                this.logger.log(Level.INFO, message, throwable);
                break;
            }
            case WARNING: {
                this.logger.log(Level.WARNING, message, throwable);
                break;
            }
            case SEVERE: {
                this.logger.log(Level.SEVERE, message, throwable);
                break;
            }
        }
    }

    public LoggerImpl(Logger logger, ISRConsole console) {
        this.logger = logger;
        this.console = console;
    }
}

