/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils.log;

import java.io.File;
import net.skinsrestorer.shared.interfaces.ISRLogger;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.YamlConfig;
import net.skinsrestorer.shared.utils.log.SRLogLevel;

public class SRLogger {
    private final ISRLogger logger;
    private final boolean color;

    public SRLogger(File pluginFolder, ISRLogger logger) {
        this(pluginFolder, logger, false);
    }

    public SRLogger(File pluginFolder, ISRLogger logger, boolean color) {
        this.logger = logger;
        this.color = color;
    }

    public void load(File pluginFolder) {
        try {
            File pluginConfigFile = new File(pluginFolder, "config.yml");
            YamlConfig pluginConfig = new YamlConfig(pluginFolder, "config.yml", false, this);
            if (pluginConfigFile.exists()) {
                pluginConfig.reload();
                if (pluginConfig.getBoolean("Debug")) {
                    Config.DEBUG = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void debug(String message) {
        this.debug(SRLogLevel.INFO, message);
    }

    public void debug(SRLogLevel level, String message) {
        if (!Config.DEBUG) {
            return;
        }
        this.log(level, message);
    }

    public void debug(SRLogLevel level, String message, Throwable thrown) {
        if (!Config.DEBUG) {
            return;
        }
        this.log(level, message, thrown);
    }

    public void info(String message) {
        this.log(SRLogLevel.INFO, message);
    }

    public void info(String message, Throwable thrown) {
        this.log(SRLogLevel.INFO, message, thrown);
    }

    public void warning(String message) {
        this.log(SRLogLevel.WARNING, message);
    }

    public void warning(String message, Throwable thrown) {
        this.log(SRLogLevel.WARNING, message, thrown);
    }

    public void severe(String message) {
        this.log(SRLogLevel.SEVERE, message);
    }

    public void severe(String message, Throwable thrown) {
        this.log(SRLogLevel.SEVERE, message, thrown);
    }

    private void log(SRLogLevel level, String message) {
        this.logger.log(level, this.color ? "\u00a7e[\u00a72SkinsRestorer\u00a7e] \u00a7r" + message : message);
    }

    private void log(SRLogLevel level, String message, Throwable thrown) {
        this.logger.log(level, this.color ? "\u00a7e[\u00a72SkinsRestorer\u00a7e] \u00a7r" + message : message, thrown);
    }
}

