/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge;

import com.flowpowered.math.vector.Vector3d;
import java.util.Collection;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.sponge.SkinsRestorer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.storage.WorldProperties;

public class SkinApplierSponge {
    private final SkinsRestorer plugin;

    protected void applySkin(Player player, IProperty property) {
        this.setTexture(property, player.getProfile().getPropertyMap().get((Object)"textures"));
        Sponge.getScheduler().createSyncExecutor((Object)this.plugin).execute(() -> this.sendUpdate(player));
    }

    public void updateProfileSkin(GameProfile profile, String skin) throws SkinRequestException {
        this.setTexture(this.plugin.getSkinStorage().getSkinForPlayer(skin), profile.getPropertyMap().get((Object)"textures"));
    }

    private void setTexture(IProperty property, Collection<ProfileProperty> oldProperties) {
        ProfileProperty newTextures = Sponge.getServer().getGameProfileManager().createProfileProperty("textures", property.getValue(), property.getSignature());
        oldProperties.removeIf(property2 -> property2.getName().equals("textures"));
        oldProperties.add(newTextures);
    }

    private void sendUpdate(Player receiver) {
        receiver.getTabList().removeEntry(receiver.getUniqueId());
        receiver.getTabList().addEntry(TabListEntry.builder().displayName((Text)receiver.getDisplayNameData().displayName().get()).latency(receiver.getConnection().getLatency()).list(receiver.getTabList()).gameMode((GameMode)receiver.getGameModeData().type().get()).profile(receiver.getProfile()).build());
        Location loc = receiver.getLocation();
        Vector3d rotation = receiver.getRotation();
        for (WorldProperties w : Sponge.getServer().getAllWorldProperties()) {
            if (w.getUniqueId().equals(receiver.getWorld().getUniqueId())) continue;
            Sponge.getServer().loadWorld(w.getUniqueId());
            Sponge.getServer().getWorld(w.getUniqueId()).ifPresent(value -> receiver.setLocation(value.getSpawnLocation()));
            receiver.setLocationAndRotation(loc, rotation);
            break;
        }
        receiver.offer(Keys.VANISH, (Object)true);
        Sponge.getScheduler().createTaskBuilder().execute(() -> receiver.offer(Keys.VANISH, (Object)false)).delayTicks(1L).submit((Object)this.plugin);
    }

    public SkinApplierSponge(SkinsRestorer plugin) {
        this.plugin = plugin;
    }
}

