/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge.commands;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.shadow.aikar.commands.BaseCommand;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandAlias;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandCompletion;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandPermission;
import net.skinsrestorer.shadow.aikar.commands.annotation.Description;
import net.skinsrestorer.shadow.aikar.commands.annotation.HelpCommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Optional;
import net.skinsrestorer.shadow.aikar.commands.annotation.Single;
import net.skinsrestorer.shadow.aikar.commands.annotation.Subcommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Syntax;
import net.skinsrestorer.shadow.aikar.commands.sponge.contexts.OnlinePlayer;
import net.skinsrestorer.shadow.gson.JsonObject;
import net.skinsrestorer.shadow.gson.JsonParser;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.utils.C;
import net.skinsrestorer.shared.utils.connections.ServiceChecker;
import net.skinsrestorer.shared.utils.log.SRLogger;
import net.skinsrestorer.sponge.SkinsRestorer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;

@CommandAlias(value="sr|skinsrestorer")
@CommandPermission(value="%sr")
public class SrCommand
extends BaseCommand {
    private final SkinsRestorer plugin;
    private final SRLogger logger;

    @HelpCommand
    @Syntax(value=" [help]")
    public void onHelp(CommandSource source, CommandHelp help) {
        help.showHelp();
    }

    @Subcommand(value="reload")
    @CommandPermission(value="%srReload")
    @Description(value="%helpSrReload")
    public void onReload(CommandSource source) {
        Locale.load(this.plugin.getDataFolder(), this.logger);
        Config.load(this.plugin.getDataFolder(), this.plugin.getClass().getClassLoader().getResourceAsStream("config.yml"), this.logger);
        this.plugin.prepareACF(this.plugin.getManager(), this.plugin.getSrLogger());
        source.sendMessage(this.plugin.parseMessage(Locale.RELOAD));
    }

    @Subcommand(value="status")
    @CommandPermission(value="%srStatus")
    @Description(value="%helpSrStatus")
    public void onStatus(CommandSource source) {
        Sponge.getScheduler().createAsyncExecutor((Object)this.plugin).execute(() -> {
            source.sendMessage(this.plugin.parseMessage("\u00a73----------------------------------------------"));
            source.sendMessage(this.plugin.parseMessage("\u00a77Checking needed services for SR to work properly..."));
            ServiceChecker checker = new ServiceChecker();
            checker.setMojangAPI(this.plugin.getMojangAPI());
            checker.checkServices();
            ServiceChecker.ServiceCheckResponse response = checker.getResponse();
            List<String> results = response.getResults();
            if (Config.DEBUG || response.getWorkingUUID().get() < 1 || response.getWorkingProfile().get() < 1) {
                for (String result : results) {
                    if (!Config.DEBUG && !result.contains("\u2718")) continue;
                    source.sendMessage(this.plugin.parseMessage(result));
                }
            }
            source.sendMessage(this.plugin.parseMessage("\u00a77Working UUID API count: \u00a76" + response.getWorkingUUID()));
            source.sendMessage(this.plugin.parseMessage("\u00a77Working Profile API count: \u00a76" + response.getWorkingProfile()));
            if (response.getWorkingUUID().get() >= 1 && response.getWorkingProfile().get() >= 1) {
                source.sendMessage(this.plugin.parseMessage("\u00a7aThe plugin currently is in a working state."));
            } else {
                source.sendMessage(this.plugin.parseMessage("\u00a7cPlugin currently can't fetch new skins. \n Connection is likely blocked because of firewall. \n Please See http://skinsrestorer.net/firewall for more info"));
            }
            source.sendMessage(this.plugin.parseMessage("\u00a73----------------------------------------------"));
            source.sendMessage(this.plugin.parseMessage("\u00a77SkinsRestorer \u00a76v" + this.plugin.getVersion()));
            source.sendMessage(this.plugin.parseMessage("\u00a77Server: \u00a76" + Sponge.getGame().getPlatform().getMinecraftVersion()));
            source.sendMessage(this.plugin.parseMessage("\u00a77BungeeMode: \u00a76Sponge-Plugin"));
            source.sendMessage(this.plugin.parseMessage("\u00a77Finished checking services."));
            source.sendMessage(this.plugin.parseMessage("\u00a73----------------------------------------------"));
        });
    }

    @Subcommand(value="drop|remove")
    @CommandPermission(value="%srDrop")
    @CommandCompletion(value="PLAYER|SKIN @players @players @players")
    @Description(value="%helpSrDrop")
    @Syntax(value=" <player|skin> <target> [target2]")
    public void onDrop(CommandSource source, PlayerOrSkin playerOrSkin, String[] targets) {
        Sponge.getScheduler().createAsyncExecutor((Object)this.plugin).execute(() -> {
            if (playerOrSkin == PlayerOrSkin.PLAYER) {
                for (String targetPlayer : targets) {
                    this.plugin.getSkinStorage().removeSkin(targetPlayer);
                }
            } else {
                for (String targetSkin : targets) {
                    this.plugin.getSkinStorage().removeSkinData(targetSkin);
                }
            }
            String targetList = Arrays.toString(targets).substring(1, Arrays.toString(targets).length() - 1);
            source.sendMessage(this.plugin.parseMessage(Locale.DATA_DROPPED.replace("%playerOrSkin", playerOrSkin.toString()).replace("%targets", targetList)));
        });
    }

    @Subcommand(value="props")
    @CommandPermission(value="%srProps")
    @CommandCompletion(value="@players")
    @Description(value="%helpSrProps")
    @Syntax(value=" <target>")
    public void onProps(CommandSource source, @Single OnlinePlayer target) {
        Sponge.getScheduler().createAsyncExecutor((Object)this.plugin).execute(() -> {
            Collection prop = target.getPlayer().getProfile().getPropertyMap().get((Object)"textures");
            if (prop == null) {
                source.sendMessage(this.plugin.parseMessage(Locale.NO_SKIN_DATA));
                return;
            }
            prop.forEach(profileProperty -> {
                byte[] decoded = Base64.getDecoder().decode(profileProperty.getValue());
                String decodedString = new String(decoded);
                JsonObject jsonObject = JsonParser.parseString(decodedString).getAsJsonObject();
                String decodedSkin = jsonObject.getAsJsonObject().get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").toString();
                long timestamp = Long.parseLong(jsonObject.getAsJsonObject().get("timestamp").toString());
                String requestDate = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(timestamp));
                source.sendMessage(this.plugin.parseMessage("\u00a7aRequest time: \u00a7e" + requestDate));
                source.sendMessage(this.plugin.parseMessage("\u00a7aprofileId: \u00a7e" + jsonObject.getAsJsonObject().get("profileId").toString()));
                source.sendMessage(this.plugin.parseMessage("\u00a7aName: \u00a7e" + jsonObject.getAsJsonObject().get("profileName").toString()));
                source.sendMessage(this.plugin.parseMessage("\u00a7aSkinTexture: \u00a7e" + decodedSkin.substring(1, decodedSkin.length() - 1)));
                source.sendMessage(this.plugin.parseMessage("\u00a7cMore info in console!"));
                this.logger.info("\u00a7aName: \u00a78" + profileProperty.getName());
                this.logger.info("\u00a7aValue : \u00a78" + profileProperty.getValue());
                this.logger.info("\u00a7aSignature : \u00a78" + profileProperty.getSignature());
                this.logger.info("\u00a7aValue Decoded: \u00a7e" + Arrays.toString(decoded));
            });
        });
    }

    @Subcommand(value="applyskin")
    @CommandPermission(value="%srApplySkin")
    @CommandCompletion(value="@players")
    @Description(value="%helpSrApplySkin")
    @Syntax(value=" <target>")
    public void onApplySkin(CommandSource source, @Single OnlinePlayer target) {
        Sponge.getScheduler().createAsyncExecutor((Object)this.plugin).execute(() -> {
            try {
                String skin = this.plugin.getSkinStorage().getDefaultSkinName(target.getPlayer().getName());
                this.plugin.getSkinApplierSponge().updateProfileSkin(target.getPlayer().getProfile(), skin);
                source.sendMessage(this.plugin.parseMessage("success: player skin has been refreshed!"));
            }
            catch (SkinRequestException ignored) {
                source.sendMessage(this.plugin.parseMessage("ERROR: player skin could NOT be refreshed!"));
            }
        });
    }

    @Subcommand(value="createcustom")
    @CommandPermission(value="%srCreateCustom")
    @CommandCompletion(value="@skinName @skinUrl")
    @Description(value="%helpSrCreateCustom")
    @Syntax(value=" <skinName> <skinUrl> [steve/slim]")
    public void onCreateCustom(CommandSource source, String name, String skinUrl, @Optional SkinType skinType) {
        Sponge.getScheduler().createAsyncExecutor((Object)this.plugin).execute(() -> {
            try {
                if (C.validUrl(skinUrl)) {
                    this.plugin.getSkinStorage().setSkinData(name, this.plugin.getMineSkinAPI().genSkin(skinUrl, String.valueOf((Object)skinType), null), Long.toString(System.currentTimeMillis() + 3153600000000L));
                    source.sendMessage(this.plugin.parseMessage(Locale.SUCCESS_CREATE_SKIN.replace("%skin", name)));
                } else {
                    source.sendMessage(this.plugin.parseMessage(Locale.ERROR_INVALID_URLSKIN));
                }
            }
            catch (SkinRequestException e) {
                source.sendMessage(this.plugin.parseMessage(e.getMessage()));
            }
        });
    }

    @Subcommand(value="setskinall")
    @CommandCompletion(value="@Skin")
    @Description(value="Set the skin to evey player")
    @Syntax(value=" <Skin / Url> [steve/slim]")
    public void onSetSkinAll(CommandSource source, String skin, @Optional SkinType skinType) {
        Sponge.getScheduler().createAsyncExecutor((Object)this.plugin).execute(() -> {
            if (source != Sponge.getServer().getConsole()) {
                source.sendMessage(this.plugin.parseMessage(Locale.PREFIX + "&4Only console may execute this command!"));
            }
            String skinName = " \u00b7setSkinAll";
            try {
                IProperty skinProps = null;
                skinProps = C.validUrl(skin) ? this.plugin.getMineSkinAPI().genSkin(skin, String.valueOf((Object)skinType), null) : (IProperty)this.plugin.getMojangAPI().getSkin(skin).orElse(null);
                if (skinProps == null) {
                    source.sendMessage(this.plugin.parseMessage(Locale.PREFIX + "&4no skin found...."));
                    return;
                }
                this.plugin.getSkinStorage().setSkinData(skinName, skinProps);
                for (Player player : Sponge.getServer().getOnlinePlayers()) {
                    String pName = player.getName();
                    this.plugin.getSkinStorage().setSkinName(pName, skinName);
                    this.plugin.getSkinsRestorerAPI().applySkin(new PlayerWrapper(player), skinProps);
                }
            }
            catch (SkinRequestException e) {
                source.sendMessage(this.plugin.parseMessage(e.getMessage()));
            }
        });
    }

    public SrCommand(SkinsRestorer plugin, SRLogger logger) {
        this.plugin = plugin;
        this.logger = logger;
    }

    public static enum PlayerOrSkin {
        PLAYER,
        SKIN;

    }

    public static enum SkinType {
        STEVE,
        SLIM;

    }
}

