/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.sponge.listeners;

import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.utils.log.SRLogger;
import net.skinsrestorer.sponge.SkinsRestorer;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.profile.GameProfile;

public class LoginListener
implements EventListener<ClientConnectionEvent.Auth> {
    private final SkinsRestorer plugin;
    private final SRLogger log;

    public void handle(ClientConnectionEvent.Auth event) {
        if (event.isCancelled() && Config.NO_SKIN_IF_LOGIN_CANCELED) {
            return;
        }
        if (Config.DISABLE_ON_JOIN_SKINS) {
            return;
        }
        GameProfile profile = event.getProfile();
        profile.getName().ifPresent(name -> {
            try {
                this.plugin.getSkinApplierSponge().updateProfileSkin(profile, this.plugin.getSkinStorage().getDefaultSkinName((String)name));
            }
            catch (SkinRequestException skinRequestException) {
                // empty catch block
            }
        });
    }

    public LoginListener(SkinsRestorer plugin, SRLogger log) {
        this.plugin = plugin;
        this.log = log;
    }
}

