/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.util.GameProfile;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.shared.utils.log.SRLogger;
import net.skinsrestorer.velocity.SkinsRestorer;

public class SkinApplierVelocity {
    private final SkinsRestorer plugin;
    private final SRLogger log;

    protected void applySkin(Player player, IProperty property) {
        player.setGameProfileProperties(this.updatePropertiesSkin(player.getGameProfileProperties(), (GameProfile.Property)property.getHandle()));
        this.sendUpdateRequest(player, (GameProfile.Property)property.getHandle());
    }

    public GameProfile updateProfileSkin(GameProfile profile, String skin) throws SkinRequestException {
        GameProfile.Property textures = (GameProfile.Property)this.plugin.getSkinStorage().getSkinForPlayer(skin).getHandle();
        List oldProperties = profile.getProperties();
        List<GameProfile.Property> newProperties = this.updatePropertiesSkin(oldProperties, textures);
        return new GameProfile(profile.getId(), profile.getName(), newProperties);
    }

    private List<GameProfile.Property> updatePropertiesSkin(List<GameProfile.Property> original, GameProfile.Property property) {
        ArrayList<GameProfile.Property> properties = new ArrayList<GameProfile.Property>(original);
        boolean applied = false;
        for (int i = 0; i < properties.size(); ++i) {
            GameProfile.Property lProperty = (GameProfile.Property)properties.get(i);
            if (!"textures".equals(lProperty.getName())) continue;
            properties.set(i, property);
            applied = true;
        }
        if (!applied) {
            properties.add(property);
        }
        return properties;
    }

    private void sendUpdateRequest(Player player, GameProfile.Property textures) {
        player.getCurrentServer().ifPresent(serverConnection -> {
            this.log.debug("Sending skin update request for " + player.getUsername());
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("SkinUpdate");
                if (textures != null) {
                    out.writeUTF(textures.getName());
                    out.writeUTF(textures.getValue());
                    out.writeUTF(textures.getSignature());
                }
                serverConnection.sendPluginMessage((ChannelIdentifier)MinecraftChannelIdentifier.create((String)"sr", (String)"skinchange"), b.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public SkinApplierVelocity(SkinsRestorer plugin, SRLogger log) {
        this.plugin = plugin;
        this.log = log;
    }
}

