/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.SkinsRestorerAPI;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.serverinfo.Platform;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.aikar.commands.VelocityCommandManager;
import net.skinsrestorer.shadow.bstats.charts.SingleLineChart;
import net.skinsrestorer.shadow.bstats.velocity.Metrics;
import net.skinsrestorer.shadow.spiget.UpdateCallback;
import net.skinsrestorer.shared.interfaces.ISRPlugin;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.storage.SkinStorage;
import net.skinsrestorer.shared.update.UpdateChecker;
import net.skinsrestorer.shared.update.UpdateCheckerGitHub;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.SharedMethods;
import net.skinsrestorer.shared.utils.WrapperFactory;
import net.skinsrestorer.shared.utils.connections.MineSkinAPI;
import net.skinsrestorer.shared.utils.connections.MojangAPI;
import net.skinsrestorer.shared.utils.log.SRLogger;
import net.skinsrestorer.shared.utils.log.Slf4LoggerImpl;
import net.skinsrestorer.velocity.SkinApplierVelocity;
import net.skinsrestorer.velocity.command.SkinCommand;
import net.skinsrestorer.velocity.command.SrCommand;
import net.skinsrestorer.velocity.listener.GameProfileRequest;
import org.slf4j.Logger;

@Plugin(id="skinsrestorer", name="SkinsRestorer", version="14.1.10", description="Ability to restore/change skins on servers! (Offline and Online Mode)", url="https://skinsrestorer.net/", authors={"Blackfire62", "McLive"})
public class SkinsRestorer
implements ISRPlugin {
    private final ProxyServer proxy;
    private final ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private final Metrics.Factory metricsFactory;
    private final MetricsCounter metricsCounter = new MetricsCounter();
    private final File dataFolder;
    private final SRLogger srLogger;
    private final MojangAPI mojangAPI;
    private final SkinStorage skinStorage;
    private final SkinsRestorerAPI skinsRestorerAPI;
    private final MineSkinAPI mineSkinAPI;
    private final SkinApplierVelocity skinApplierVelocity;
    private UpdateChecker updateChecker;
    private CommandManager<?, ?, ?, ?, ?, ?> manager;
    @Inject
    private PluginContainer container;

    @Inject
    public SkinsRestorer(ProxyServer proxy, Metrics.Factory metricsFactory, @DataDirectory Path dataFolderPath, Logger logger) {
        this.proxy = proxy;
        this.metricsFactory = metricsFactory;
        this.dataFolder = dataFolderPath.toFile();
        this.srLogger = new SRLogger(this.dataFolder, new Slf4LoggerImpl(logger));
        this.mojangAPI = new MojangAPI(this.srLogger, Platform.VELOCITY, this.metricsCounter);
        this.mineSkinAPI = new MineSkinAPI(this.srLogger, this.mojangAPI, this.metricsCounter);
        this.skinStorage = new SkinStorage(this.srLogger, this.mojangAPI, this.mineSkinAPI);
        this.skinsRestorerAPI = new SkinsRestorerVelocityAPI(this.mojangAPI, this.skinStorage);
        this.skinApplierVelocity = new SkinApplierVelocity(this, this.srLogger);
    }

    @Subscribe
    public void onProxyInitialize(ProxyInitializeEvent event) {
        this.srLogger.load(this.getDataFolder());
        File updaterDisabled = new File(this.dataFolder, "noupdate.txt");
        Metrics metrics = this.metricsFactory.make(this, 10606);
        metrics.addCustomChart(new SingleLineChart("mineskin_calls", this.metricsCounter::collectMineskinCalls));
        metrics.addCustomChart(new SingleLineChart("minetools_calls", this.metricsCounter::collectMinetoolsCalls));
        metrics.addCustomChart(new SingleLineChart("mojang_calls", this.metricsCounter::collectMojangCalls));
        metrics.addCustomChart(new SingleLineChart("ashcon_calls", this.metricsCounter::collectAshconCalls));
        if (!updaterDisabled.exists()) {
            this.updateChecker = new UpdateCheckerGitHub(2124, this.getVersion(), this.srLogger, "SkinsRestorerUpdater/Velocity");
            this.checkUpdate(true);
            Random rn = new Random();
            int delayInt = 60 + rn.nextInt(181);
            this.proxy.getScheduler().buildTask((Object)this, this::checkUpdate).repeat((long)delayInt, TimeUnit.MINUTES).delay((long)delayInt, TimeUnit.MINUTES).schedule();
        } else {
            this.srLogger.info("Updater Disabled");
        }
        Config.load(this.dataFolder, this.getResource("config.yml"), this.srLogger);
        Locale.load(this.dataFolder, this.srLogger);
        if (!this.initStorage()) {
            return;
        }
        this.proxy.getEventManager().register((Object)this, (Object)new GameProfileRequest(this, this.srLogger));
        this.initCommands();
        this.srLogger.info("Enabled SkinsRestorer v" + this.getVersion());
        SharedMethods.runServiceCheck(this.mojangAPI, this.srLogger);
    }

    private void initCommands() {
        this.manager = new VelocityCommandManager(this.proxy, this);
        this.prepareACF(this.manager, this.srLogger);
        this.manager.registerCommand(new SkinCommand(this, this.srLogger));
        this.manager.registerCommand(new SrCommand(this, this.srLogger, this.proxy));
    }

    private boolean initStorage() {
        if (!SharedMethods.initMysql(this.srLogger, this.skinStorage, this.dataFolder)) {
            return false;
        }
        this.getService().execute(this.skinStorage::preloadDefaultSkins);
        return true;
    }

    private void checkUpdate() {
        this.checkUpdate(false);
    }

    private void checkUpdate(final boolean showUpToDate) {
        this.getService().execute(() -> this.updateChecker.checkForUpdate(new UpdateCallback(){

            @Override
            public void updateAvailable(String newVersion, String downloadUrl, boolean hasDirectDownload) {
                SkinsRestorer.this.updateChecker.getUpdateAvailableMessages(newVersion, downloadUrl, hasDirectDownload, SkinsRestorer.this.getVersion(), false).forEach(SkinsRestorer.this.srLogger::info);
            }

            @Override
            public void upToDate() {
                if (showUpToDate) {
                    SkinsRestorer.this.updateChecker.getUpToDateMessages(SkinsRestorer.this.getVersion(), false).forEach(SkinsRestorer.this.srLogger::info);
                }
            }
        }));
    }

    public TextComponent deserialize(String string) {
        return LegacyComponentSerializer.legacySection().deserialize(string);
    }

    @Override
    public String getVersion() {
        return this.container.getDescription().getVersion().orElse("Unknown");
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public ExecutorService getService() {
        return this.service;
    }

    public Metrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    @Override
    public MetricsCounter getMetricsCounter() {
        return this.metricsCounter;
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder;
    }

    public SRLogger getSrLogger() {
        return this.srLogger;
    }

    public MojangAPI getMojangAPI() {
        return this.mojangAPI;
    }

    @Override
    public SkinStorage getSkinStorage() {
        return this.skinStorage;
    }

    public SkinsRestorerAPI getSkinsRestorerAPI() {
        return this.skinsRestorerAPI;
    }

    public MineSkinAPI getMineSkinAPI() {
        return this.mineSkinAPI;
    }

    public SkinApplierVelocity getSkinApplierVelocity() {
        return this.skinApplierVelocity;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public CommandManager<?, ?, ?, ?, ?, ?> getManager() {
        return this.manager;
    }

    public PluginContainer getContainer() {
        return this.container;
    }

    private class SkinsRestorerVelocityAPI
    extends SkinsRestorerAPI {
        public SkinsRestorerVelocityAPI(MojangAPI mojangAPI, SkinStorage skinStorage) {
            super(mojangAPI, SkinsRestorer.this.mineSkinAPI, skinStorage, new WrapperFactoryVelocity());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper) throws SkinRequestException {
            this.applySkin(playerWrapper, playerWrapper.get(Player.class).getUsername());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, String name) throws SkinRequestException {
            this.applySkin(playerWrapper, SkinsRestorer.this.skinStorage.getSkinForPlayer(name));
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, IProperty props) {
            SkinsRestorer.this.skinApplierVelocity.applySkin(playerWrapper.get(Player.class), props);
        }
    }

    private static class WrapperFactoryVelocity
    extends WrapperFactory {
        private WrapperFactoryVelocity() {
        }

        @Override
        public ISRPlayer wrap(final Object playerInstance) {
            if (playerInstance instanceof Player) {
                final Player player = (Player)playerInstance;
                return new ISRPlayer(){

                    @Override
                    public PlayerWrapper getWrapper() {
                        return new PlayerWrapper(playerInstance);
                    }

                    @Override
                    public String getName() {
                        return player.getUsername();
                    }

                    @Override
                    public void sendMessage(String message) {
                        player.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(message));
                    }
                };
            }
            throw new IllegalArgumentException("Player instance is not valid!");
        }
    }
}

