/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity.listener;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.utils.log.SRLogger;
import net.skinsrestorer.velocity.SkinsRestorer;

public class GameProfileRequest {
    private final SkinsRestorer plugin;
    private final SRLogger log;

    @Subscribe
    public void onGameProfileRequest(GameProfileRequestEvent event) {
        if (Config.DISABLE_ON_JOIN_SKINS) {
            return;
        }
        if (event.isOnlineMode()) {
            return;
        }
        String name = event.getUsername();
        String skin = this.plugin.getSkinStorage().getDefaultSkinName(name);
        try {
            event.setGameProfile(this.plugin.getSkinApplierVelocity().updateProfileSkin(event.getGameProfile(), skin));
        }
        catch (SkinRequestException skinRequestException) {
            // empty catch block
        }
    }

    public GameProfileRequest(SkinsRestorer plugin, SRLogger log) {
        this.plugin = plugin;
        this.log = log;
    }
}

